<?php
namespace App\Controllers;

/* Here to load required models */
use App\Models\UsersModel;

// Require the Autoload file
require_once COMPOSER_PATH;

// Begin Auth class that is an extension of BaseController
class Auth extends NotAuthenticatedBaseController
{


	/**
	 * INDEX METHOD
	 * FIRST TO BE LOADED
	 */
	public function index()
	{

		// Check wether the user is already connected or not
		if(
			! empty($this->session)
			&& ! empty($this->session->connected)
			&& $this->session->connected === true
		) {

			// Redirect the user to the dashboard controller
			return redirect()->to(base_url($this->data['locale'] . '/dashboard'));

		} // End if

		// Load the loginForm method as default one
		$this->loginForm();

	} // end::index

    

    /**
	 * DISPLAY AUTHENTICATION PAGE
	 */
	public function loginForm()
	{

		// Check wether the user is already connected or not
		if(
			! empty($this->session)
			&& ! empty($this->session->connected)
			&& $this->session->connected === true
		) {

			// Redirect the user to the dashboard controller
			return redirect()->to(base_url($this->data['locale'] . '/dashboard'));

		} // End if


		/* Localization */
		$signInLanguagePath = "Language/{$this->data['locale']}/SignIn.php";
		$signInLanguageFile = (file_exists(APPPATH . $signInLanguagePath)) ? require_once APPPATH . $signInLanguagePath : '';
		$profileLanguagePath = "Language/{$this->data['locale']}/Profile.php";
		$profileLanguageFile = (file_exists(APPPATH . $profileLanguagePath)) ? require_once APPPATH . $profileLanguagePath : '';

		// Set all the data required for the following view
		$this->data['page']	= [
			'signIn'	=> $this->view->setData($this->data)->render('auth/_partials/signIn'),
			'forgotPwd'	=> $this->view->setData($this->data)->render('auth/_partials/forgotPwd'),
		];

		// Set the page details
		$this->data['pageDetails']	= [
			'localization'	=> [
				'signIn'		=> $signInLanguageFile,
				'profile'		=> $profileLanguageFile,
			],
		];

		// Render the view that corresponds
		print view('auth/main', $this->data);

	} // end::signIn

    

    /**
	 * LOG OUT A CONNECTED USER
	 */
	public function signOut()
	{

		// Unset the session security information
        $this->session->destroy();

		// Redirect the user to the Authentication form
		return redirect()->to(base_url());

	} // end::signOut

    

    /**
	 * AUTHENTICATE A USER
	 * USING HIS CREDENTIALS
	 * 
	 * @param   array  $_POST
	 * 
	 * @return  array  $response
	 */
	public function signIn()
	{

		// Get the received data
		$login = $this->request->getVar('txt-login');
		$password = $this->request->getVar('txt-pwd');

		// Load the required models
        $usersModel = new UsersModel(); // users

        // Set the data to process
        $data = [
        	'login'		=> $login,
        	'password'	=> $password,
        ];

        // Try to authenticate the user
        $response = $usersModel->authentication($data);

        // Process only if there is any user informations returned
        if($response['code'] === 'success') {
                    
            // Create the user session
            $this->session->set('connected', true);
            $this->session->set('user', $usersModel->_formatProfileData($response['data']));

        } // End if

		// Return the function response
		return $this->response->setJSON($response);

	} // end::signIn


} // end::Auth
