<?php

/* Namespace the app controller */
namespace App\Controllers;

/* Here to load required models */
use App\Models\UsersModel;

// begin::Home
class Home extends BaseController
{


    /**
     * INDEX METHOD
     * FIRST TO BE LOADED
     */
    public function index()
    {

        // Check wether the user is already connected or not
        if(empty($this->session->connected))
        {

            // Redirect the user to the dashboard controller
            return redirect()->to(base_url($this->data['locale'] . '/sign/out'));

        } // End if

        // Load the dashboard method as default one
        $this->dashboard();

    } // end::index

    

    /**
     * DISPLAY USER DASHBOARD
     */
    public function dashboard()
    {

        // Check wether the user is already connected or not
        if(empty($this->session->connected))
        {

            // Log out the current user then redirect him to the sign in page
            return redirect()->to(base_url($this->data['locale'] . '/sign/out'));

        } // End if


        /* Localization */
        $dashboardLanguagePath = "Language/{$this->data['locale']}/Dashboard.php";
        $dashboardLanguageFile = (file_exists(APPPATH . $dashboardLanguagePath)) ? require_once APPPATH . $dashboardLanguagePath : '';


        // Set all the page scripts to load
        $this->data['pageScripts']  = [

            // Dashboard scripts
            'custom/dashboard/dashboard.js',

        ];

        // Set all the plugin scripts to load
        $this->data['pluginScripts']    = [

            // Flot charts
            'flot/flot.bundle.js?v=7.0.6',

        ];

        // Specify the menu to highlight
        $this->data['activeMenu']['home']['dashboard']  = 'menu-item-active';

        // Specify page details informations
        $this->data['pageDetails']  = [
            'title'         => ucfirst(lang('Dashboard.title')),
            'description'   => ucfirst(lang('Dashboard.description')),
            'localization'  => [
                'dashboard'  => $dashboardLanguageFile,
            ],
        ];

        // Load the page content
        $this->template->render('home/dashboard', $this->data);

    } // end::dashboard

    

    /**
     * USER PROFILE INFORMATIONS
     */
    public function profile()
    {

        // Check wether the user is already connected or not
        if(empty($this->session->connected))
        {

            // Redirect the user to the dashboard controller
            return redirect()->to(base_url($this->data['locale'] . '/sign/out'));

        } // End if


        /* Localization */
        $profileLanguagePath = "Language/{$this->data['locale']}/Profile.php";
        $profileLanguageFile = (file_exists(APPPATH . $profileLanguagePath)) ? require_once APPPATH . $profileLanguagePath : '';

        // Set all the page styles to load
        $this->data['pageStyles']   = [

            // Wizard style file
            'wizard/wizard-2.css?v=7.0.6',

        ];

        // Set all the page scripts to load
        $this->data['pageScripts']  = [

            // Profile scripts
            'custom/profile/profile.js',

        ];

        // Specify the menu to highlight
        $this->data['activeMenu']['home']['profile']    = 'menu-item-active';

        // Specify page details informations
        $this->data['pageDetails']  = [
            'title'         => ucfirst(lang('Profile.title')),
            'description'   => ucfirst($this->session->user['firstName']) . ' ' . mb_strtoupper($this->session->user['lastName']),
            'localization'  => [
                'profile'   => $profileLanguageFile,
            ],
        ];

        // Try to get any alert message to display
        $this->data['alertMessage'] = (! empty($this->session->getFlashdata('message'))) ? $this->session->getFlashdata('message') : [];

        // Set all the partials page data to load
        $this->data['partials'] = [
            'password'      => $this->view->setData($this->data)->render('profile/_partials/password/_form'),
            'infos'         => $this->view->setData($this->data)->render('profile/_partials/infos/_form'),
        ];

        // Render the page content that corresponds
        $this->template->render('profile/main', $this->data);

    } // end::profile

    

    /**
     * UPDATE USER PROFILE
     */
    public function setProfile()
    {

        // Get all the posted form
        $firstName = (! empty($this->request->getPost('txt-first-name'))) ? trim($this->request->getPost('txt-first-name')) : '';
        $lastName = (! empty($this->request->getPost('txt-last-name'))) ? trim($this->request->getPost('txt-last-name')) : '';
        $email = (! empty($this->request->getPost('txt-email'))) ? trim($this->request->getPost('txt-email')) : '';
        $phone = (! empty($this->request->getPost('txt-phone'))) ? trim($this->request->getPost('txt-phone')) : '';

        // Set the form data to send to the API
        $data = [
            'rowID'     => $this->session->user['id'],
            'firstName' => $firstName,
            'lastName'  => $lastName,
            'email'     => $email,
            'phone'     => $phone,
        ];

        // Load the required models
        $usersModel = new UsersModel(); // users

        // Perform requested action
        $return = $usersModel->_setProfile($data);

        // Process only if there is any user informations returned
        if($return['code'] === 'success') {
                    
            // Update user session
            $this->session->push('user', ['firstName' => $return['data']['firstName']]);
            $this->session->push('user', ['lastName' => $return['data']['lastName']]);
            $this->session->push('user', ['email' => $return['data']['email']]);
            $this->session->push('user', ['phone' => $return['data']['phone']]);

        } // End if

        // Return the function response
        return $this->response->setJSON($return);

    } // end::setProfile

    

    /**
     * UPDATE USER PASSWORD
     */
    public function setPasswd()
    {

        // Get all the posted form
        $current = (! empty($this->request->getPost('txt-current'))) ? trim($this->request->getPost('txt-current')) : '';
        $new = (! empty($this->request->getPost('txt-new'))) ? trim($this->request->getPost('txt-new')) : '';

        // Set the form data to send to the API
        $data = [
            'rowID'     => $this->session->user['id'],
            'email'     => $this->session->user['email'],
            'current'   => $current,
            'new'       => $new,
        ];

        // Load the required models
        $usersModel = new UsersModel(); // users

        // Perform requested action
        $return = $usersModel->_setPassword($data);

        // Return the function response
        return $this->response->setJSON($return);

    } // End function


} // end::Home