<?php namespace App\Models;

// Call Model Namespace
use CodeIgniter\Model;

// Begin PermissionsModel class
class PermissionsModel extends Model
{

    // Defined all the required data
    protected $table = 'permission';
    protected $primaryKey = 'id';

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;
    
    protected $allowedFields = ['id', 'name', 'description', 'code', 'active', 'deleted', 'created_by', 'deleted_by', 'created_at', 'deleted_at', 'updated_at'];

    protected $searchFields = ['name', 'description', 'code', 'created_at'];
    protected $sortingFields = [
        'name'          => 'name',
        'description'   => 'description',
        'code'          => 'code',
        'created_at'    => 'created_at',
    ];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function list($id = 0, $options = [])
        {

            // Check wether an id has been specified or not
            if ($id === 0)
            {

                // Get any pagination option specified
                $paging = ( ! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
                $page = ( ! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
                $length = ( ! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
                $sorting = ( ! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
                $field = ( ! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
                $sort = ( ! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

                // Adjust the query if the paging option is specified
                if( ! empty($page))
                {

                    // Set the offset value
                    $offset = ($page - 1) * $length;

                    // Add paging option
                    $this->limit($length, $offset);

                } // End if

                // Adjust the query if the sorting option is specified
                if( ! empty($field)
                    && array_key_exists($field, $this->sortingFields)
                )
                {

                    // Add sorting option
                    $this->orderBy($this->sortingFields[$field], $sort);

                } // End if

                // Returns all the rows availables
                return $this->where([
                                'active'        => 1,
                                'deleted'       => 0,
                                'deleted_by'    => null,
                            ])
                            ->get()
                            ->getResultArray();

            } // End if

            // Return the row details
            return $this->asArray()
                        ->where([
                            $this->primaryKey => $id
                        ])
                        ->first(); // Return the first item

        } // End function
    //-----------------------------------------------------------------

    //------------------------------------------
    // CHECK WETHER A ROW IS A DUPLICATE OR NOT
    //------------------------------------------
        public function isDuplicate($where = [], $orWhere = [])
        {

            // Set the default answer to return
            $isDuplicate = true;

            // Try to get the row
            $row = $this->where($where)
                        ->groupStart()
                            ->orWhere($orWhere)
                        ->groupEnd()
                        ->get()
                        ->getResultArray();

            // Check the row
            if( empty($row))
            {

                // Set the row as not duplicate
                $isDuplicate = false;

            } // End if

            // Return the answer
            return $isDuplicate;

        } // End function
    //------------------------------------------

    //-------------------------------
    // COUNT ALL THE ROWS AVAILABLES
    //-------------------------------
        public function countTotal($keyword = '', $allFields = true)
        {

            // Process only if the keyword is not empty
            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->countAllResults();

            } // End if

            // Return the rows that match even if the keyword is empty
            return $this->like($this->searchFields[0], $keyword)
                        ->countAllResults();

        } // End function
    //-------------------------------

    //-------------------------------------------
    // LIST ALL THE ROWS THAT MATCHS THE KEYWORD
    //-------------------------------------------
        public function search($keyword = '', $allFields = true, $options = [])
        {

            // Get any pagination option specified
            $paging = ( ! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
            $page = ( ! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
            $length = ( ! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
            $sorting = ( ! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
            $field = ( ! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
            $sort = ( ! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

            // Adjust the query if the paging option is specified
            if( ! empty($page))
            {

                // Set the offset value
                $offset = ($page - 1) * $length;

                // Add paging option
                $this->limit($length, $offset);

            } // End if

            // Adjust the query if the sorting option is specified
            if( ! empty($field)
                && array_key_exists($field, $this->sortingFields)
            )
            {

                // Add sorting option
                $this->orderBy($this->sortingFields[$field], $sort);

            } // End if

            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->get()
                            ->getResultArray();

            } // End if

            // Process only if the keyword is not empty
            return $this->like($this->searchFields[0], $keyword)
                        ->get()
                        ->getResultArray();

        } // End function
    //-------------------------------------------

    //---------------------------------------------------------
    // RETURN AN ARRAY OF COLUMN WHERE TO LOOK FOR THE KEYWORD
    //---------------------------------------------------------
        protected function _searchArray($keyword = '')
        {

            // Set the default data to return
            $data = [];

            // Loop through all the fields then add the keyword as value
            foreach($this->searchFields as $searchField)
            {
                
                // Set a new array item
                $data["$searchField"] = $keyword;

            } // End loop

            // Return data as function response
            return $data;


        } // End function
    //---------------------------------------------------------

} // End PermissionsModel class