----
----
-- DATATABLES QUERIES | 09 June 2022
----
----

--
-- ALTER TABLE `user` DROP INDEX `user_email`
--
ALTER TABLE `user` DROP INDEX `user_email`;

--
-- ALTER TABLE `user` DROP INDEX `user_phone`
--
ALTER TABLE `user` DROP INDEX `user_phone`;




----
----
-- DATATABLES QUERIES | 07 June 2022
----
----

--
-- INSERT INTO `role`
--
INSERT INTO `role` (`id`, `name`, `description`, `active`, `deleted`, `created_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES (NULL, 'Root', 'Has all access by default', '1', '0', NULL, NULL, CURRENT_TIMESTAMP, NULL, NULL);

--
-- CREATE TABLE `permission`
--
CREATE TABLE `permission` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `code` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) UNSIGNED DEFAULT NULL,
  `deleted_by` int(10) UNSIGNED DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE `permission_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- ALTER TABLE `permission` ADD KEYS
--
ALTER TABLE `permission`
  ADD KEY `permission_created_by` (`created_by`),
  ADD KEY `permission_deleted_by` (`deleted_by`);

--
-- ALTER TABLE `permission` ADD CONSTRAINTS
--
ALTER TABLE `permission`
  ADD CONSTRAINT `permission_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `permission_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`);

--
-- CREATE TABLE `role_permission
--
CREATE TABLE `role_permission` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `role_id` int(10) UNSIGNED NOT NULL,
  `permission_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- ALTER TABLE `role_permission` ADD KEYS
--
ALTER TABLE `role_permission`
  ADD KEY `role_permission_role_id` (`role_id`),
  ADD KEY `role_permission_permission_id` (`permission_id`);

--
-- ALTER TABLE `role_permission` ADD CONSTRAINTS
--
ALTER TABLE `role_permission`
  ADD CONSTRAINT `role_permission_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `permission` (`id`),
  ADD CONSTRAINT `role_permission_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`);

--
-- INSERT INTO `permission`
--
INSERT INTO `permission` (`id`, `name`, `description`, `code`, `active`, `deleted`, `created_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES (NULL, 'Developer', 'A developer level allows to use every action', 'dev_mode', '1', '0', NULL, NULL, CURRENT_TIMESTAMP, NULL, NULL);

--
-- INSERT INTO `role_permission`
--
INSERT INTO `role_permission` (`id`, `role_id`, `permission_id`) VALUES (NULL, '1', '1');

--
-- ALTER TABLE `user` ADD KEYS
--
ALTER TABLE `user`
  ADD KEY `user_created_by` (`created_by`),
  ADD KEY `user_deleted_by` (`deleted_by`),
  ADD KEY `user_role_id` (`role_id`);

--
-- ALTER TABLE `user` ADD CONSTRAINTS
--
ALTER TABLE `user`
  ADD CONSTRAINT `user_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`);

--
-- ALTER TABLE `business_unit` ADD KEYS
--
ALTER TABLE `business_unit`
  ADD KEY `business_unit_created_by` (`created_by`),
  ADD KEY `business_unit_deleted_by` (`deleted_by`);

--
-- ALTER TABLE `business_unit` ADD CONSTRAINTS
--
ALTER TABLE `business_unit`
  ADD CONSTRAINT `business_unit_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `business_unit_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`);

--
-- ALTER TABLE `role` ADD KEYS
--
ALTER TABLE `role`
  ADD KEY `role_created_by` (`created_by`),
  ADD KEY `role_deleted_by` (`deleted_by`);

--
-- ALTER TABLE `role` ADD CONSTRAINTS
--
ALTER TABLE `role`
  ADD CONSTRAINT `role_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `role_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`);

--
-- ALTER TABLE `user_identifier` ADD KEYS
--
ALTER TABLE `user_identifier`
  ADD KEY `user_identifier_user_id` (`user_id`),
  ADD KEY `user_identifier_created_by` (`created_by`),
  ADD KEY `user_identifier_deleted_by` (`deleted_by`);

--
-- ALTER TABLE `user_identifier` ADD CONSTRAINTS
--
ALTER TABLE `user_identifier`
  ADD CONSTRAINT `user_identifier_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_identifier_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_identifier_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`);

--
-- ALTER TABLE `user_business_unit` ADD KEYS
--
ALTER TABLE `user_business_unit`
  ADD KEY `user_business_unit_user_id` (`user_id`),
  ADD KEY `user_business_unit_business_unit_id` (`business_unit_id`),
  ADD KEY `user_business_unit_created_by` (`created_by`),
  ADD KEY `user_business_unit_deleted_by` (`deleted_by`);

--
-- ALTER TABLE `user_business_unit` ADD CONSTRAINTS
--
ALTER TABLE `user_business_unit`
  ADD CONSTRAINT `user_business_unit_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_business_unit_business_unit_id` FOREIGN KEY (`business_unit_id`) REFERENCES `business_unit` (`id`),
  ADD CONSTRAINT `user_business_unit_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `user_business_unit_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `user` (`id`);




----
----
-- DATATABLES QUERIES | 02 June 2022
----
----

--
-- CREATE TABLE `user`
--
CREATE TABLE `user` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT , `role_id` INT(10) UNSIGNED NULL DEFAULT NULL , `first_name` VARCHAR(255) NULL DEFAULT NULL , `last_name` VARCHAR(255) NULL DEFAULT NULL , `phone` VARCHAR(20) NULL DEFAULT NULL , `email` VARCHAR(255) NULL DEFAULT NULL , `pwd` VARCHAR(255) NULL DEFAULT NULL , `random_salt` VARCHAR(255) NULL DEFAULT NULL , `recovery_code` VARCHAR(255) NULL DEFAULT NULL , `recovered_at` DATETIME NULL DEFAULT NULL , `pwd_updated_at` DATETIME NULL DEFAULT NULL , `active` TINYINT(1) NOT NULL DEFAULT '0' , `deleted` TINYINT(1) NOT NULL DEFAULT '0' , `created_by` INT(10) UNSIGNED NULL DEFAULT NULL , `deleted_by` INT(10) UNSIGNED NULL DEFAULT NULL , `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP , `updated_at` DATETIME NULL DEFAULT NULL , `deleted_at` DATETIME NULL DEFAULT NULL , PRIMARY KEY (`id`), UNIQUE `user_email` (`email`), UNIQUE `user_phone` (`phone`)) ENGINE = InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

--
-- ALTER TABLE `user` UPDATE PROPERTY `updated_at`
--
ALTER TABLE `user` CHANGE `updated_at` `updated_at` DATETIME on update CURRENT_TIMESTAMP NULL DEFAULT NULL;

--
-- ALTER TABLE `user` ADDING FOREIGN KEY AND CONSTRAINT TO `created_by` PROPERTY
--
ALTER TABLE `user`
ADD INDEX `user_created_by`(`created_by`),
ADD CONSTRAINT `user_created_by`
FOREIGN KEY (`created_by`) REFERENCES `user`(`id`);

--
-- ALTER TABLE `user` ADDING FOREIGN KEY AND CONSTRAINT TO `deleted_by` PROPERTY
--
ALTER TABLE `user`
ADD INDEX `user_deleted_by`(`deleted_by`),
ADD CONSTRAINT `user_deleted_by`
FOREIGN KEY (`deleted_by`) REFERENCES `user`(`id`);

--
-- CREATE TABLE `role`
--
CREATE TABLE `role` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT , `name` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL , `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL , `active` TINYINT(1) NOT NULL DEFAULT '0' , `deleted` TINYINT(1) NOT NULL DEFAULT '0' , `created_by` INT(10) UNSIGNED NULL DEFAULT NULL , `deleted_by` INT(10) UNSIGNED NULL DEFAULT NULL , `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP , `updated_at` DATETIME on update CURRENT_TIMESTAMP NULL DEFAULT NULL , `deleted_at` DATETIME NULL DEFAULT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

--
-- CREATE TABLE `business_unit`
--
CREATE TABLE `business_unit` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT , `name` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL , `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL , `active` TINYINT(1) NOT NULL DEFAULT '0' , `deleted` TINYINT(1) NOT NULL DEFAULT '0' , `created_by` INT(10) UNSIGNED NULL DEFAULT NULL , `deleted_by` INT(10) UNSIGNED NULL DEFAULT NULL , `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP , `updated_at` DATETIME on update CURRENT_TIMESTAMP NULL DEFAULT NULL , `deleted_at` DATETIME NULL DEFAULT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

--
-- CREATED TABLE `user_business_unit`
--
CREATE TABLE `user_business_unit` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT , `user_id` INT(10) UNSIGNED NOT NULL , `business_unit_id` INT(10) UNSIGNED NOT NULL , `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL , `active` TINYINT(1) NOT NULL DEFAULT '0' , `deleted` TINYINT(1) NOT NULL DEFAULT '0' , `created_by` INT(10) UNSIGNED NULL DEFAULT NULL , `deleted_by` INT(10) UNSIGNED NULL DEFAULT NULL , `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP , `updated_at` DATETIME on update CURRENT_TIMESTAMP NULL DEFAULT NULL , `deleted_at` DATETIME NULL DEFAULT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

--
-- CREATE TABLE `user_identifier`
--
CREATE TABLE `siages_database`.`user_identifier` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT , `user_id` INT(10) UNSIGNED NOT NULL , `name` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL , `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL , `active` TINYINT(1) NOT NULL DEFAULT '0' , `deleted` TINYINT(1) NOT NULL DEFAULT '0' , `created_by` INT(10) UNSIGNED NULL DEFAULT NULL , `deleted_by` INT(10) UNSIGNED NULL DEFAULT NULL , `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP , `updated_at` DATETIME on update CURRENT_TIMESTAMP NULL DEFAULT NULL , `deleted_at` DATETIME NULL DEFAULT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB CHARSET=utf8 COLLATE utf8_general_ci;