<?php

// Test
// ...
// var_dump($this->data);
// var_dump($alertMessage);
// var_dump($alertMessage);

// Get any sent alert message
$alertMessage = (! empty($alertMessage)) ? $alertMessage : '';

?>

<!--begin::Signin-->
<div class="login-form login-signin">
    <div class="text-center mb-10 mb-lg-20">
        <h2 class="font-weight-bold"><?= ucfirst(lang('SignIn.title')); ?></h2>
        <p class="text-muted font-weight-bold"><?= ucfirst(lang('SignIn.description')); ?> !</p>
    </div>

    <?php

    // Process only if there is a message to display
    if(! empty($alertMessage))
    {

    ?>
    <!--begin::ProcessingAlerts-->
    <div class="alert alert-custom alert-outline-2x alert-outline-danger fade show mb-5" role="alert">
        <div class="alert-icon"><i class="flaticon-warning"></i></div>
        <div class="alert-text"><?= esc($alertMessage); ?></div>
        <div class="alert-close">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true"><i class="ki ki-close"></i></span>
            </button>
        </div>
    </div>
    <!--end::ProcessingAlerts-->

    <?php

    } // End if

    ?>

    <!--begin::Form-->
    <form class="form" method="post" novalidate="novalidate" id="login_signin_form">

        <?= csrf_field() ?>
        
        <div class="form-group py-3 m-0">
            <input class="form-control h-auto border-0 px-0" type="Email" placeholder="<?= ucfirst(lang('SignIn.field.login.placeholder')); ?>" name="txt-login" autocomplete="off" />
        </div>
        <div class="form-group py-3 border-top m-0">
            <input class="form-control h-auto border-0 px-0" type="Password" placeholder="<?= ucfirst(lang('SignIn.field.password.placeholder')); ?>" name="txt-pwd" />
        </div>

        <div class="form-group d-flex flex-wrap justify-content-between align-items-center mt-3">
            <div class="checkbox-inline">
                <label class="checkbox checkbox-outline m-0 text-muted">
                    <input type="checkbox" name="chk-remember" />
                    <span></span>
                    <?= ucfirst(lang('SignIn.field.stayConnected.label')); ?>
                </label>
            </div>
            <a href="javascript:;" id="login_forgot" class="text-muted text-hover-primary"><?= ucfirst(lang('ForgotPassword.title')); ?> ?</a>
        </div>

        <div class="form-group align-items-center mt-2">
            <div class="text-right">
                <button id="login_signin_submit" class="btn btn-primary font-weight-bold px-9 py-4 my-3"><?= ucfirst(lang('SignIn.action.signIn')); ?></button>
            </div>
        </div>
    </form>
    <!--end::Form-->
</div>
<!--end::Signin-->
