<?php

// Test
// ...
// var_dump($_SESSION);
// exit;

// Code here
// ...

?>


<!DOCTYPE html>
<!--
Template Name: Metronic by KeenThemes
Author: XSEL Services
Website: http://www.xsel-services.com/
Contact: info@xsel-services.com
Project: https://xselsms.com/
-->
<html lang="en">
<!--begin::Head-->

<head>
    <base href="<?= base_url(); ?>/">
    <meta charset="utf-8" />
    <title><?= ucfirst(lang('SignIn.title')); ?> | <?= mb_strtoupper(lang('Project.title')); ?></title>
    <meta name="description" content="<?= ucfirst(lang('Project.description')); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!--begin::Fonts-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <!--end::Fonts-->

    <!--begin::Page Custom Styles(used by this page)-->
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/pages/login/classic/login-2.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/global/css/custom/login/classic/login-2.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <!--end::Page Custom Styles-->

    <!--begin::Global Theme Styles(used by all pages)-->
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/plugins/plugins.bundle.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/plugins/custom/prismjs/prismjs.bundle.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/main/style.bundle.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <!--end::Global Theme Styles-->

    <!--begin::Layout Themes(used by all pages)-->
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/main/header/base/light.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/main/header/menu/light.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/main/brand/dark.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>/assets/themes/layout1/css/main/aside/dark.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <!--end::Layout Themes-->

    <!--begin::Theme Skin-->
    <link href="<?= base_url(); ?>/assets/global/css/skins/default.css?v=7.0.6" rel="stylesheet" type="text/css" />
    <!--end::Theme Skin-->

    <!-- Project favicon picture -->
    <link rel="shortcut icon" href="<?= base_url(); ?>/assets/global/media/logos/favicon-02.png" />

        

    <script>

        // Localization
        var LANG_FILE = {
            project: <?= json_encode($langFile['project']); ?>,
            general: <?= json_encode($langFile['general']); ?>,
            dates: <?= json_encode($langFile['dates']); ?>,
        };

    </script>

</head>
<!--end::Head-->

<!--begin::Body-->

<body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">

    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">
        <!--begin::Login-->
        <div class="login login-2 login-signin-on d-flex flex-column flex-lg-row flex-row-fluid bg-white" id="auth_login">
        <!-- <div class="login login-2 login-signin-on d-flex flex-column flex-lg-row flex-row-fluid bg-white" id="kt_login"> -->
            <!--begin::Aside-->
            <div class="login-aside order-2 order-lg-1 d-flex flex-column-fluid flex-lg-row-auto bgi-size-cover bgi-no-repeat p-7 p-lg-10" id="loginContainer">
                <!--begin: Aside Container-->
                <div class="d-flex flex-row-fluid flex-column justify-content-between">
                    <!--begin::Aside body-->
                    <div class="d-flex flex-column-fluid flex-column flex-center mt-lg-0">
                        <a href="<?= base_url(); ?>" class="mb-5 text-center">
                            <img src="<?= base_url(); ?>/assets/global/media/logos/logo.png" class="max-h-75px" alt="logo <?= lang('Project.title'); ?>" />
                        </a>

                        <!-- Print the partial code thats corresponds to the signIn form -->
                        <?= $page['signIn']; ?>

                        <!-- Print the partial code thats corresponds to the forgotPwd form -->
                        <?= $page['forgotPwd']; ?>

                    </div>
                    <!--end::Aside body-->

                    <!--begin: Aside footer for desktop-->
                    <div class="d-flex flex-column-auto justify-content-between">
                    <!-- <div class="d-flex flex-column-auto justify-content-between mt-15"> -->
                        <div class="text-dark-50 font-weight-bold order-2 order-sm-1 my-2">
                            &copy; <?= date('Y'); ?> <?= mb_strtoupper(lang('Project.title')); ?>
                        </div>
                        <div class="d-flex order-1 order-sm-2 my-2">
                            <a target="_blank" href="<?= $project->site; ?>" class="text-muted text-hover-primary"><?= ucfirst(lang('Project.action.website')); ?></a>
                            <a href="#" class="text-muted text-hover-primary ml-4">|</a>
                            <a target="_blank" href="<?= $project->site; ?>" class="text-muted text-hover-primary ml-4"><?= ucfirst(lang('General.action.contactUs')); ?></a>
                        </div>
                    </div>
                    <!--end: Aside footer for desktop-->
                </div>
                <!--end: Aside Container-->
            </div>
            <!--begin::Aside-->

            <!--begin::Content-->
            <div class="order-1 order-lg-2 flex-column-auto flex-lg-row-fluid d-flex flex-column p-7" style="background-image: url(<?= base_url(); ?>/assets/global/media/bg/bg-auth.jpg); background-size: cover;">
                <!--begin::Content body-->
                <div class="d-flex flex-column-fluid flex-lg-center">
                    <div class="d-flex flex-column justify-content-center bg-text">
                        <h3 class="display-3 font-weight-bold my-7 text-white"><?= ucfirst(lang('Project.action.welcome')) . ' ' . mb_strtoupper(lang('Project.title')); ?> !</h3>
                        <p class="font-weight-bold font-size-lg text-white opacity-80">
                            <?= ucfirst(lang('Project.description')); ?>.
                        </p>
                    </div>
                </div>
                <!--end::Content body-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Login-->
    </div>
    <!--end::Main-->

    <!-- Activation Code Form Modal-->
    <div class="modal fade" id="loginActivationFormModal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content" id="mainContent">
                <!-- Modal Form Content -->
            </div>
        </div>
    </div>


    <script>
        LANG_FILE['page'] = <?= json_encode($pageDetails['localization']); ?>;
    </script>


    <script>
        var LOCALE = "<?= $locale; ?>";
        var BASE_URL = "<?= base_url(); ?>";
        // var HOST_URL = "https://preview.keenthemes.com/metronic/theme/html/tools/preview";

    </script>
    <!--begin::Global Config(global config for global JS scripts)-->
    <script>
        var KTAppSettings = {
            "breakpoints": {
                "sm": 576,
                "md": 768,
                "lg": 992,
                "xl": 1200,
                "xxl": 1400
            },
            "colors": {
                "theme": {
                    "base": {
                        "white": "#ffffff",
                        "primary": "#3699FF",
                        "secondary": "#E5EAEE",
                        "success": "#1BC5BD",
                        "info": "#8950FC",
                        "warning": "#FFA800",
                        "danger": "#F64E60",
                        "light": "#E4E6EF",
                        "dark": "#181C32"
                    },
                    "light": {
                        "white": "#ffffff",
                        "primary": "#E1F0FF",
                        "secondary": "#EBEDF3",
                        "success": "#C9F7F5",
                        "info": "#EEE5FF",
                        "warning": "#FFF4DE",
                        "danger": "#FFE2E5",
                        "light": "#F3F6F9",
                        "dark": "#D6D6E0"
                    },
                    "inverse": {
                        "white": "#ffffff",
                        "primary": "#ffffff",
                        "secondary": "#3F4254",
                        "success": "#ffffff",
                        "info": "#ffffff",
                        "warning": "#ffffff",
                        "danger": "#ffffff",
                        "light": "#464E5F",
                        "dark": "#ffffff"
                    }
                },
                "gray": {
                    "gray-100": "#F3F6F9",
                    "gray-200": "#EBEDF3",
                    "gray-300": "#E4E6EF",
                    "gray-400": "#D1D3E0",
                    "gray-500": "#B5B5C3",
                    "gray-600": "#7E8299",
                    "gray-700": "#5E6278",
                    "gray-800": "#3F4254",
                    "gray-900": "#181C32"
                }
            },
            "font-family": "Poppins"
        };

    </script>
    <!--end::Global Config-->

    <!--begin::Global Theme Bundle(used by all pages)-->
    <script src="<?= base_url(); ?>/assets/themes/layout1/js/plugins/plugins.bundle.js?v=7.0.6"></script>
    <script src="<?= base_url(); ?>/assets/themes/layout1/js/plugins/custom/prismjs/prismjs.bundle.js?v=7.0.6"></script>
    <script src="<?= base_url(); ?>/assets/themes/layout1/js/main/scripts.bundle.js?v=7.0.6"></script>
    <!--end::Global Theme Bundle-->


    <!-- Global scripts -->
    <script src="<?= base_url(); ?>/assets/global/js/custom/global.js"></script>


    <!--begin::Page Scripts(used by this page)-->
    <script src="<?= base_url(); ?>/assets/themes/layout1/js/pages/custom/login/login-general.js?v=7.0.6"></script>
    <!--end::Page Scripts-->
</body>
<!--end::Body-->

</html>