<?php

// Test
// ...
// var_dump($row);
// exit;

// Get all the informations for the required page
$rowID = ( ! empty($row['id']) && intval($row['id']) > 0) ? intval($row['id']) : 0;
$roleID = ( ! empty($row['role']) && ! empty($row['role']['id']) && intval($row['role']['id']) > 0) ? intval($row['role']['id']) : 0;
$lastName = ( ! empty($row['lastName'])) ? $row['lastName'] : '';
$firstName = ( ! empty($row['firstName'])) ? $row['firstName'] : '';
$email = ( ! empty($row['email'])) ? $row['email'] : '';
$phone = ( ! empty($row['phone'])) ? $row['phone'] : '';

// Get all the data list
$roles = ( ! empty($data) && ! empty($data['roles'])) ? $data['roles'] : [];

// Set all the form data
$formID = 'userForm';
$formTitle = ( ! empty($rowID) && ! empty($name)) ? ucfirst($name) : ucfirst(lang('Users.action.new'));
$formHeaderBgColor = ( ! empty($rowID)) ? 'bg-warning' : 'bg-theme-primary';
$formConfirmBtnColor = ( ! empty($rowID)) ? 'btn-warning' : 'btn-theme-primary';
$formCancelBtnColor = ( ! empty($rowID)) ? 'btn-light-warning' : 'btn-theme-light-primary';

?>

<form action="<?= esc($action); ?>" method="post" id="<?= $formID; ?>" enctype="multipart/form-data">

    <?= csrf_field() ?>

    <div class="modal-header <?= $formHeaderBgColor; ?>">
        <h5 class="modal-title text-light" id="exampleModalLabel"><?= $formTitle; ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="<?= ucfirst(lang('General.action.close')); ?>">
			<i aria-hidden="true" class="ki ki-close text-light"></i>
		</button>
    </div>
    <div class="modal-body">
        <div class="form-group row">
            <div class="col-md-7">
                <label for="txt-first-name"><?= ucfirst(lang('Profile.field.firstName.label')); ?> :</label>
                <input type="text" id="txt-first-name" name="txt-first-name" class="form-control form-control-solid" placeholder="<?= ucfirst(lang('Profile.field.firstName.placeholder')); ?>" value="<?= $firstName; ?>" />
                <span class="form-text text-muted"><?= ucfirst(lang('Profile.field.firstName.description')); ?></span>
            </div>
            <div class="col-md-5">
                <label for="txt-last-name"><?= ucfirst(lang('Profile.field.lastName.label')); ?> <span class="text-danger">*</span> :</label>
                <input type="text" id="txt-last-name" name="txt-last-name" class="form-control form-control-solid" placeholder="<?= ucfirst(lang('Profile.field.lastName.placeholder')); ?>" value="<?= $lastName; ?>" />
                <span class="form-text text-muted"><?= ucfirst(lang('Profile.field.lastName.description')); ?></span>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-7">
    			<label for="txt-email"><?= ucfirst(lang('Profile.field.email.label')); ?> <span class="text-danger">*</span> :</label>
    			<input type="email" id="txt-email" name="txt-email" class="form-control form-control-solid" placeholder="<?= ucfirst(lang('Profile.field.email.placeholder')); ?>" value="<?= $email; ?>" />
    			<span class="form-text text-muted"><?= ucfirst(lang('Profile.field.email.description')); ?></span>
            </div>
            <div class="col-md-5">
                <label for="txt-phone"><?= ucfirst(lang('Profile.field.phone.label')); ?> <span class="text-danger">*</span> :</label>
                <input type="text" id="txt-phone" name="txt-phone" class="form-control form-control-solid" placeholder="<?= ucfirst(lang('Profile.field.phone.placeholder')); ?>" value="<?= $phone; ?>" />
                <span class="form-text text-muted"><?= ucfirst(lang('Profile.field.phone.description')); ?></span>
            </div>
		</div>
        <div class="form-group">
            <label for="slt-role"><?= ucfirst(lang('Users.field.role.label')); ?> <span class="text-danger">*</span> :</label>
            <select name="slt-role" class="form-control select2" data-placeholder="<?= ucfirst(lang('Users.field.role.placeholder')); ?>" placeholder="Rôle de l'utilisateur" data-style="btn-success">
                <option value=""><?= ucfirst(lang('Users.field.role.placeholder')); ?></option>

                <?php

                // Process only if there is any role available
                if( ! empty($roles))
                {

                    // Loop through all the roles then display each
                    foreach($roles as $role)
                    {

                        // Set the selected option
                        $selected = (intval($role['id']) === intval($roleID)) ? 'selected="selected"' : '';

                ?>
                <option value="<?= $role['id']; ?>" <?= $selected; ?>><?= $role['name']; ?></option>
                <?php

                    } // End loop

                } // End if

                ?>
            </select>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn <?= $formCancelBtnColor; ?> font-weight-bold" data-dismiss="modal">
        	<?= ucfirst(lang('General.action.cancel')); ?>
        </button>
        <button type="submit" class="btn <?= $formConfirmBtnColor; ?> font-weight-bold">
        	<span class="svg-icon svg-icon-md">
        		<?= ucfirst(lang('General.action.save')); ?>
        		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
				    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
				        <polygon points="0 0 24 0 24 24 0 24"/>
				        <path d="M9.26193932,16.6476484 C8.90425297,17.0684559 8.27315905,17.1196257 7.85235158,16.7619393 C7.43154411,16.404253 7.38037434,15.773159 7.73806068,15.3523516 L16.2380607,5.35235158 C16.6013618,4.92493855 17.2451015,4.87991302 17.6643638,5.25259068 L22.1643638,9.25259068 C22.5771466,9.6195087 22.6143273,10.2515811 22.2474093,10.6643638 C21.8804913,11.0771466 21.2484189,11.1143273 20.8356362,10.7474093 L17.0997854,7.42665306 L9.26193932,16.6476484 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(14.999995, 11.000002) rotate(-180.000000) translate(-14.999995, -11.000002) "/>
				        <path d="M4.26193932,17.6476484 C3.90425297,18.0684559 3.27315905,18.1196257 2.85235158,17.7619393 C2.43154411,17.404253 2.38037434,16.773159 2.73806068,16.3523516 L11.2380607,6.35235158 C11.6013618,5.92493855 12.2451015,5.87991302 12.6643638,6.25259068 L17.1643638,10.2525907 C17.5771466,10.6195087 17.6143273,11.2515811 17.2474093,11.6643638 C16.8804913,12.0771466 16.2484189,12.1143273 15.8356362,11.7474093 L12.0997854,8.42665306 L4.26193932,17.6476484 Z" fill="#000000" fill-rule="nonzero" transform="translate(9.999995, 12.000002) rotate(-180.000000) translate(-9.999995, -12.000002) "/>
				    </g>
				</svg>
        	</span>
        </button>
    </div>

    <!-- Set all the hidden data -->
    <input type="hidden" name="row-ID" value="<?= $rowID; ?>">
</form>

<script type="text/javascript">
    $('.select2').select2();
</script>