<?php

// Test
// ...
// var_dump($packages);
// exit;

// Set all the required reloading CRUD informations
$reloadingsFormModalID = 'reloadingFormModal';
$reloadingsDtButtons = [
    'add'       => 'reloadingFormAdd',
    'reload'    => 'reloadReloadingDatatable',
];

// Get all the required data
$packs = (! empty($packages)) ? $packages : [];

?>
<div class="dropdown">
    <!--begin::Toggle-->
    <div class="topbar-item" data-toggle="dropdown" data-offset="10px,0px">
        <div class="btn btn-icon btn-info btn-hover-light-info w-auto btn-clean d-inline-flex align-items-center btn-lg px-2 mr-1">
            <span class="svg-icon">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <rect x="0" y="0" width="24" height="24"/>
                        <path d="M16.3740377,19.9389434 L22.2226499,11.1660251 C22.4524142,10.8213786 22.3592838,10.3557266 22.0146373,10.1259623 C21.8914367,10.0438285 21.7466809,10 21.5986122,10 L17,10 L17,4.47708173 C17,4.06286817 16.6642136,3.72708173 16.25,3.72708173 C15.9992351,3.72708173 15.7650616,3.85240758 15.6259623,4.06105658 L9.7773501,12.8339749 C9.54758575,13.1786214 9.64071616,13.6442734 9.98536267,13.8740377 C10.1085633,13.9561715 10.2533191,14 10.4013878,14 L15,14 L15,19.5229183 C15,19.9371318 15.3357864,20.2729183 15.75,20.2729183 C16.0007649,20.2729183 16.2349384,20.1475924 16.3740377,19.9389434 Z" fill="#000000"/>
                        <path d="M4.5,5 L9.5,5 C10.3284271,5 11,5.67157288 11,6.5 C11,7.32842712 10.3284271,8 9.5,8 L4.5,8 C3.67157288,8 3,7.32842712 3,6.5 C3,5.67157288 3.67157288,5 4.5,5 Z M4.5,17 L9.5,17 C10.3284271,17 11,17.6715729 11,18.5 C11,19.3284271 10.3284271,20 9.5,20 L4.5,20 C3.67157288,20 3,19.3284271 3,18.5 C3,17.6715729 3.67157288,17 4.5,17 Z M2.5,11 L6.5,11 C7.32842712,11 8,11.6715729 8,12.5 C8,13.3284271 7.32842712,14 6.5,14 L2.5,14 C1.67157288,14 1,13.3284271 1,12.5 C1,11.6715729 1.67157288,11 2.5,11 Z" fill="#000000" opacity="0.3"/>
                    </g>
                </svg>
            </span>
            <span class="ml-2"><?= ucfirst(lang('Reloading.action.reloadCustomer')); ?></span>
        </div>
    </div>
    <!--end::Toggle-->

    <!--begin::Dropdown-->
    <div class="dropdown-menu p-0 m-0 dropdown-menu-right dropdown-menu-anim-up dropdown-menu-lg">
        <!--begin:Header-->
        <div class="d-flex flex-column flex-center py-10 bgi-size-cover bgi-no-repeat rounded-top" style="background-image: url(<?= base_url(); ?>/assets/global/media/misc/bg-1.jpg)">
            <h4 class="text-white font-weight-bold">
                <?= ucfirst(lang('Reloading.field.pack.description')); ?>
            </h4>
        </div>
        <!--end:Header-->

        <!--begin:Nav-->
        <div class="row row-paddingless flex-center">

            <?php

            // Process only if there is any pack available
            if(! empty($packs))
            {

                // Loop through all the packs then display each
                foreach($packs as $pack)
                {

            ?>
            <!--begin:Item-->
            <div class="col-6">
                <a href="javascript:;" class="d-block py-10 px-5 text-center bg-hover-light border-right border-bottom <?= $reloadingsDtButtons['add']; ?>" data-toggle="modal" data-target="#<?= $reloadingsFormModalID; ?>" data-row-id="0" data-pack-ID="<?= intval($pack['id']); ?>">
                    <span class="svg-icon svg-icon-3x svg-icon-success">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <rect x="0" y="0" width="24" height="24"/>
                                <path d="M4,6 L20,6 C20.5522847,6 21,6.44771525 21,7 L21,8 C21,8.55228475 20.5522847,9 20,9 L4,9 C3.44771525,9 3,8.55228475 3,8 L3,7 C3,6.44771525 3.44771525,6 4,6 Z M5,11 L10,11 C10.5522847,11 11,11.4477153 11,12 L11,19 C11,19.5522847 10.5522847,20 10,20 L5,20 C4.44771525,20 4,19.5522847 4,19 L4,12 C4,11.4477153 4.44771525,11 5,11 Z M14,11 L19,11 C19.5522847,11 20,11.4477153 20,12 L20,19 C20,19.5522847 19.5522847,20 19,20 L14,20 C13.4477153,20 13,19.5522847 13,19 L13,12 C13,11.4477153 13.4477153,11 14,11 Z" fill="#000000"/>
                                <path d="M14.4452998,2.16794971 C14.9048285,1.86159725 15.5256978,1.98577112 15.8320503,2.4452998 C16.1384028,2.90482849 16.0142289,3.52569784 15.5547002,3.83205029 L12,6.20185043 L8.4452998,3.83205029 C7.98577112,3.52569784 7.86159725,2.90482849 8.16794971,2.4452998 C8.47430216,1.98577112 9.09517151,1.86159725 9.5547002,2.16794971 L12,3.79814957 L14.4452998,2.16794971 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                            </g>
                        </svg>
                    </span>
                    <span class="d-block text-dark-75 font-weight-bold font-size-h6 mt-2 mb-1"><?= $pack['name']; ?></span>
                    <span class="d-block text-dark-50 font-size-lg"><?= number_format($pack['amount'], 0, '.', ' '); ?> XOF</span>
                </a>
            </div>
            <!--end:Item-->
            <?php

                } // End loop

            } // End if
            else
            {

            ?>

            <p class="mt-4 text-info">
                <?= ucfirst(lang('Reloading.response.noPackAvailable')); ?>
            </p>

            <?php

            }

            ?>
        </div>
        <!--end:Nav-->
    </div>
    <!--end::Dropdown-->
</div>