"use strict";

// Class definition
var SendMessage = function () {

    // Declare variables here
    // ...
    var sltReceiversID = 'slt-receivers',
        defaultListLength = 20,
        messageTextInput = 'txt-message',
        balanceContainer = 'balanceContainer',
        formID = 'composeMessage',
        formButtons = {
            submit: 'sendMessage',
            models: 'predefinedMessage',
        },
        formComponents = {
            receiversTypeRadio: 'rd-receivers-type',
            scheduled: {
                sendAt: 'scheduledSendAt'
            },
        },
        remoteAJAXFunctions = {
            setForm: 'messages/setMessage',
            receiversListURL: 'ApiData/getContactsSelectOptions',
            contactsListURL: 'ApiData/getContactsSelectOptions',
            groupsListURL: 'ApiData/getGroupsSelectOptions',
            loadBalance: 'ApiData/getBalance',
        },
        receiversTypeArray = ['contacts', 'groups', 'all'];

    // Components
    var _initComponents = function() {


        /*
         * Call the dateTime picker plugin
         */
        $('#' + formComponents.scheduled.sendAt).datetimepicker({
            'locale': 'fr',
            // format: 'DD-MM-Y hh:mm:ss',
            format: 'DD-MM-Y LTS',
            // format: 'LLL',
            // format: 'LLLL',
            ignoreReadonly: true,
            defaultDate: moment(),
            minDate: moment(),
        });

        /*
         * Update the recurring options set
         */
        $('#slt-minute').select2({
            placeholder: '- Choisir une option -',
            minimumResultsForSearch: Infinity,
        });
        $('#slt-hour').select2({
            placeholder: '- Choisir une option -',
            minimumResultsForSearch: Infinity,
        });
        $('#slt-day').select2({
            placeholder: '- Choisir une option -',
            minimumResultsForSearch: Infinity,
        });
        $('#slt-month').select2({
            placeholder: '- Choisir une option -',
            minimumResultsForSearch: Infinity,
        });
        $('#slt-weekday').select2({
            placeholder: '- Choisir une option -',
            minimumResultsForSearch: Infinity,
        });

        // Change the right planned option input element according to the specified planned option select element
        $('select.scheduler-options').on('change', function() {

            // Get all the data required for the current select element planned options
            var schedulerOptionValue = ($(this).val()) ? $(this).val() : '';
            var schedulerOptionType = ($(this).attr('data-scheduler-option')) ? $(this).attr('data-scheduler-option') : '';

            // Process only if the required planned data are availables
            if(schedulerOptionValue !== '' && schedulerOptionType !== '') {

                // Get the specified input element we've to update value
                $('#txt-' + schedulerOptionType).val(schedulerOptionValue);
                $('#txt-' + schedulerOptionType).attr('value', schedulerOptionValue);

            } // End if

        });

        /*
         * Reload the user balance
         */
        var reloadBalance = function() {

            $('#' +  balanceContainer).load(remoteAJAXFunctions.loadBalance);

        }; // End function

        /*
         * Resize text zone
         */
        var resizeTextZone = function(textarea) {

            var messageField = KTUtil.getById(textarea); // Get the input area
            autosize(messageField); // Resize the input area
            autosize.update(messageField); // Resize the input area

        }; // End function

        // Allow the user to load a message model to the message text input
        $(document).on('click', '.' + formButtons.models, function() {

            // Test
            // ...
            // console.log($(this).attr('data-message'));

            // Focus the Text Input
            $('#' + messageTextInput).focus();

            // Replace the message text input value
            $('#' + messageTextInput).val($(this).attr('data-message'));

            // Trigger enter keypress to resize the input area
            // ...
            // var e = $.Event( "keypress", { which: 13, keyCode: 13 } );
            // $('#' + messageTextInput).change();
            // $('#' + messageTextInput).trigger(e);
            // $('#' + messageTextInput).trigger('keyup');

            // Trigger a keyup event, for chars counting
            $('#' + messageTextInput).keyup();
            // $('#' + messageTextInput).change();

            // Resize the message text input area
            var messageField = KTUtil.getById(messageTextInput); // Get the input area
            autosize(messageField); // Resize the input area
            autosize.update(messageField); // Resize the input area

        });


        /**
         * Reload the receivers list on receivers type change
         */
        $(document).on('change', 'input[type=radio][name=' + formComponents.receiversTypeRadio + ']', function () {

            // Load the receivers that corresponds
            loadReceivers(this.value);

        });


        /**
         * LOAD RECEIVERS LIST
         * CONTACTS OR GROUPS LIST
         * WITH CORRECT PLACEHOLDER
         */
        function loadReceivers(type) {

            // Get all the sent settings
            type = (type && (receiversTypeArray.indexOf(type) > -1)) ? type : 'contacts';

            // Set all the data required
            var receiversList = remoteAJAXFunctions.contactsListURL,
                placeholder = 'Ajouter un contact...';

            // Test
            // ...
            // console.log(type);

            // Switch type to set the right receivers informations
            switch(type) {

                case 'all':
                    placeholder = 'Tous les contacts sont sélectionnés';
                    receiversList = '';
                    break;

                case 'groups':
                    placeholder = 'Ajouter un groupe...';
                    receiversList = remoteAJAXFunctions.groupsListURL;
                    break;

                default:
                    break;

            } // End switch

            // Test
            // ...
            // console.log(type);
            // console.log(receiversList);
            // console.log(placeholder);

            // Load the receivers list
            if(receiversList === '')
            {

                // Clear the Select2 Box
                $('#' + sltReceiversID).val(null).trigger('change');

                // Set the data list
                var data = [{
                    id: 0,
                    text: placeholder,
                    // text: 'Tous les contacts sont sélectionnés',
                }];

                $( '#' + sltReceiversID ).select2({
                    placeholder: placeholder,
                    data: data,
                });

                // Disable the select field
                $( '#' + sltReceiversID ).attr('disabled', 'disabled');

            } else { // End if

                // var length = 20;

                // Enable the select field
                $( '#' + sltReceiversID ).removeAttr('disabled');

                // Clear the Select2 Box
                $('#' + sltReceiversID).val(null).trigger('change');

                // Init Select2 plugins for receivers select
                $( '#' + sltReceiversID ).select2({
                    placeholder: placeholder,
                    tags: true,
                    tokenSeparators: [',', ';', ' '],
                    // dropdownParent: $(this).parent(),
                    ajax: {
                        // url: remoteAJAXFunctions.receiversListURL,
                        url: BASE_URL + '/' + receiversList,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                q: params.term, // search term
                                page: params.page,
                                length: defaultListLength
                            };
                        },
                        processResults: function (data, params) {

                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            // Map the results according to the receivers type
                            if(type === 'contacts')
                            {

                                // Map the data to match the required Select2 format
                                return {
                                    results: $.map(data.items, function (obj) {
                                        return {
                                            text: obj.name + ' (' + obj.number + ')',
                                            id: obj.number
                                        }
                                    }),
                                    pagination: {
                                        more: (params.page * defaultListLength) < data.total_count
                                    }
                                };

                            } else { // End if

                                // Map the data to match the required Select2 format
                                return {
                                    results: $.map(data.items, function (obj) {
                                        return {
                                            text: obj.name,
                                            id: obj.id
                                        }
                                    }),
                                    pagination: {
                                        more: (params.page * defaultListLength) < data.total_count
                                    }
                                };

                            } // End else

                        },
                        cache: true
                    },
                    escapeMarkup: function (markup) {

                        return markup;

                    }, // let our custom formatter work
                    // minimumInputLength: 1,
                    // templateResult: formatRepo, // omitted for brevity, see the source of this page
                    // templateSelection: formatRepoSelection // omitted for brevity, see the source of this page
                });

            } // End else

        } // End function


        // Init Select2 plugins for receivers select
        $( '#' + sltReceiversID ).select2({
            placeholder: "Ajouter un destinataire...",
            tags: true,
            tokenSeparators: [',', ';', ' '],
            // dropdownParent: $(this).parent(),
            ajax: {
                // url: remoteAJAXFunctions.receiversListURL,
                url: BASE_URL + '/' + remoteAJAXFunctions.receiversListURL,
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term, // search term
                        page: params.page,
                        length: defaultListLength
                    };
                },
                processResults: function (data, params) {

                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    params.page = params.page || 1;

                    // Map the data to match the required Select2 format
                    // var mapData = $.map(data.items, function (obj) {
                    //     obj.id = obj.id || obj.number; // Set the identifier
                    //     obj.text = obj.text || obj.name; // Set the text

                    //     // Return the maped data
                    //     return obj;
                    // });

                    // Test
                    // ...
                    // console.log(mapData);
                    // console.log(obj);

                    return {
                        results: $.map(data.items, function (obj) {
                            return {
                                text: obj.name + ' (' + obj.number + ')',
                                id: obj.number
                            }
                        }),
                        pagination: {
                            more: (params.page * defaultListLength) < data.total_count
                        }
                    };

                },
                cache: true
            },
            escapeMarkup: function (markup) {
                // Test
                // ...
                // console.log(markup);

                return markup;
            }, // let our custom formatter work
            // minimumInputLength: 1,
            // templateResult: formatRepo, // omitted for brevity, see the source of this page
            // templateSelection: formatRepoSelection // omitted for brevity, see the source of this page
        });


        /*
        * SET TRUE THE AUTOSIZE PROPERTY FOR THE MESSAGE TEXT INPUT
        */
            // Get the message text input
            var messageField = KTUtil.getById(messageTextInput);

            // Process only if the field is not empty
            if (messageField) {

                // Set the autosize property
                autosize(messageField);

            } // End if
        // End function


        // Hold then process the form submit event
        $(document).on('submit', '#' + formID, function(e) {

            // Call a block UI for the whole page
            KTApp.blockPage({
                overlayColor: '#000000',
                state: 'warning',
                message: 'Traitement...'
            });

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Get all the required data
            var formElement = $('#' + formID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: BASE_URL + '/' + remoteAJAXFunctions.setForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Unblock the whole page
                    KTApp.unblockPage();

                    // Realod the user balance
                    reloadBalance();

                    // Get the data value
                    var serverResponse = JSON.parse(data);

                    // Check the response type
                    if(serverResponse.type === 'success')
                    {

                        // Clear the Select2 Box
                        $('#' + sltReceiversID).val(null).trigger('change');

                        // Reset the form
                        $('#' + formID)[0].reset();

                        // Resize the text area
                        resizeTextZone(messageTextInput);

                        // Reload the receivers list
                        loadReceivers('contacts');

                        // Push the server response as toast
                        toastr.success(serverResponse.message);

                    } // End if
                    else if(serverResponse.type === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

        });

    };

	return {
		// public functions
		init: function() {
			_initComponents(); // Init all the form components
            // _historyDT(); // Init the history dataTable
		}
	};
}();

jQuery(document).ready(function() {
	SendMessage.init();
});