<?php

// Namespace to Models folder
namespace App\Models;

// Call Model Namespace
use CodeIgniter\Model;


// begin::ModelSource class
class ModelSource extends Model
{

    // Defined all the required data
    protected $table = 'report_status';
    protected $primaryKey = 'id';

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;
    
    protected $allowedFields = ['id', 'group_id', 'code', 'description', 'active', 'deleted', 'created_by', 'deleted_by', 'created_at', 'deleted_at', 'updated_at'];
    
    protected $selectedFields = 'report_status.id, report_status.code, report_status.tags, report_status.description, report_status.active, report_status.deleted, report_status.created_by, report_status.deleted_by, report_status.created_at, report_status.deleted_at, report_status.updated_at, report_status_group.id as group_id, report_status_group.code as group_code, report_status_group.description as group_description';

    protected $searchFields = ['report_status.code', 'report_status_group.code', 'report_status.description', 'report_status.created_at'];
    protected $sortingFields = [
        'status'        => 'report_status.code',
        'group'         => 'report_status_group.code',
        'description'   => 'report_status.description',
        'created_at'    => 'report_status.created_at',
    ];


    protected $filtersFields = [
        'rowID'     => 'report_status.id',
        'tags'      => 'report_status.tags',
        'code'      => 'report_status.code',
        'groupID'   => 'report_status_group.id',
        'groupCode' => 'report_status_group.code',
        'createdAT' => 'report_status.created_at',
    ];


    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    // Set the joins array
    protected $joints = [
        [
            'table'     => 'report_status_group',
            'condition' => 'report_status_group.id = report_status.group_id',
            'type'      => 'inner',
        ],
    ];
    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function list($id = 0, $options = [])
        {

            // Set the fields list to select
            $this->select($this->selectedFields);


            /**
             * JOINTS
             * 
             * Set all the joins for the current query
             */
            $this->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type']);


            // Check wether an id has been specified or not
            if($id === 0)
            {

                // Get any pagination option specified
                $paging = (! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
                $page = (! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
                $length = (! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
                $sorting = (! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
                $field = (! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
                $sort = (! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

                // Adjust the query if the paging option is specified
                if(! empty($page))
                {

                    // Set the offset value
                    $offset = ($page - 1) * $length;

                    // Add paging option
                    $this->limit($length, $offset);

                } // End if

                // Adjust the query if the sorting option is specified
                if(! empty($field)
                    && array_key_exists($field, $this->sortingFields)
                )
                {

                    // Add sorting option
                    $this->orderBy($this->sortingFields[$field], $sort);

                } // End if

                // Returns all the rows availables
                return $this->where([
                                $this->table . '.deleted'       => 0,
                                $this->table . '.deleted_by'    => null,
                            ])
                            ->get()
                            ->getResultArray();

            } // End if

            // Return the row details
            return $this->asArray()
                        ->where([
                            $this->table . '.' . $this->primaryKey   => $id,
                        ])
                        ->first(); // Return the first item

        } // End function
    //-----------------------------------------------------------------


    /**
     * CHECK WETHER A ROW IS A DUPLICATE OR NOT
     * ACCORDING TO A SPECIFIC QUERY
     * 
     * @param   array  $where   => Where queries using AND
     * @param   array  $orWhere => Where queries using OR
     * 
     * @return  bool   $isDuplicate
     */
    public function isDuplicate($where = [], $orWhere = [])
    {

        // Set the fields list to select
        $this->select($this->table . '.' . $this->primaryKey);


        /**
         * JOINTS
         * 
         * Set all the joins for the current query
         */
        $this->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type']);


        // Set the default answer to return
        $isDuplicate = true;

        // Process only if there is a orWhere available
        if(! empty($orWhere))
        {
            
            $this->groupStart()
                    ->orWhere($orWhere)
                ->groupEnd();

        } // End if

        // Try to get the row
        $row = $this->where($where)
                    ->get()
                    ->getResultArray();

        // Check the row
        if( empty($row))
        {

            // Set the row as not duplicate
            $isDuplicate = false;

        } // End if

        // Return the answer
        return $isDuplicate;

    } // End function


    //-------------------------------
    // COUNT ALL THE ROWS AVAILABLES
    //-------------------------------
        public function countTotal($keyword = '', $allFields = true)
        {

            // Set the fields list to select
            $this->select($this->table . '.' . $this->primaryKey);


            /**
             * JOINTS
             * 
             * Set all the joins for the current query
             */
            $this->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type']);


            // Process only if the keyword is not empty
            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->countAllResults();

            } // End if

            // Return the rows that match even if the keyword is empty
            return $this->like($this->searchFields[0], $keyword)
                        ->countAllResults();

        } // End function
    //-------------------------------

    //-------------------------------------------
    // LIST ALL THE ROWS THAT MATCHS THE KEYWORD
    //-------------------------------------------
        public function search($keyword = '', $allFields = false, $options = [])
        {

            // Set the fields list to select
            $this->select($this->selectedFields);


            /**
             * JOINTS
             * 
             * Set all the joins for the current query
             */
            $this->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type']);


            // Get any pagination option specified
            $paging = (! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
            $page = (! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
            $length = (! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
            $sorting = (! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
            $field = (! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
            $sort = (! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

            // Adjust the query if the paging option is specified
            if(! empty($page))
            {

                // Set the offset value
                $offset = ($page - 1) * $length;

                // Add paging option
                $this->limit($length, $offset);

            } // End if

            // Adjust the query if the sorting option is specified
            if(! empty($field)
                && array_key_exists($field, $this->sortingFields)
            )
            {

                // Add sorting option
                $this->orderBy($this->sortingFields[$field], $sort);

            } // End if

            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->groupStart()
                                ->orLike($searchArray)
                            ->groupEnd()
                            ->findAll();

            } // End if

            // Process only if the keyword is not empty
            return $this->like($this->searchFields[0], $keyword)
                        ->findAll();

        } // End function
    //-------------------------------------------



    /**
     * GET ANY STATUS THAT MATCHES
     * THE SENT TAGS
     * 
     * @param   string  $tags
     * 
     * @return  array  $data
     * 
     */
    // begin::getDataBy
    public function getByTags(string $tags)
    {

        // Set the default data value
        $data = [];

        // Process only if there is a condition specified
        if(! empty($tags)) {

            // Get the data specified
            $data = $this->asArray()
                        ->select($this->selectedFields)
                        ->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type'])
                        ->like($this->table . '.tags', $tags)
                        ->first();

        } // End if

        return $data;

    } // end::getDataBy



    /**
     * GET ANY ROW THAT MATCHES THE SENT 
     * FILTERS ACCORDING THE LOGIC VALUE
     * 
     * @param   array  $filters
     * @param   bool   $logicOR
     * 
     * @return  array  $data
     * 
     */
    // begin::getDataBy
    public function getDataBy(array $filters, bool $logicOR = false)
    {

        // Set the default data value
        $data = [];
        
        // Get the relatives conditions
        $conditions = $this->_conditionsFromFilters($filters);

        // Process only if there is a condition specified
        if(! empty($conditions)) {

            // Get the data specified
            $data = $this->asArray()
                        ->select($this->selectedFields)
                        ->join($this->joints[0]['table'], $this->joints[0]['condition'], $this->joints[0]['type'])
                        ->where($conditions)
                        ->first();

        } // End if

        return $data;

    } // end::getDataBy



    /**
     *
     * 
     * @param   array  $filters
     * 
     * @return  array  $conditions
     * 
     *  */
    // begin::_conditionsFromFilters
    protected function _conditionsFromFilters(array $filters = [])
    {

        // Set the default condition value
        $conditions = [];

        // Process if there is any filter specified and sent
        if(! empty($filters) && ! empty($this->filtersFields)) {

            // Loop through all the filters then set the condition that fits
            foreach($filters as $key => $value) {

                // Check if the key matches any filters specified
                if(array_key_exists($key, $this->filtersFields)) {

                    // Set the condition
                    $conditions[$this->filtersFields[$key]] = $value;

                } // End if

            } // End loop

        } // End if

        // Return the response
        return $conditions;

    } // end::_conditionsFromFilters


    //---------------------------------------------------------
    // RETURN AN ARRAY OF COLUMN WHERE TO LOOK FOR THE KEYWORD
    //---------------------------------------------------------
        protected function _searchArray($keyword = '')
        {

            // Set the default data to return
            $data = [];

            // Loop through all the fields then add the keyword as value
            foreach($this->searchFields as $searchField)
            {
                
                // Set a new array item
                $data["$searchField"] = $keyword;

            } // End loop

            // Return data as function response
            return $data;


        } // End function
    //---------------------------------------------------------



    
    /**
     * SET REPORT STATUS DATA
     */
    public function _set($rowID = 0, $data = [])
    {

        // Return the function response
        $type = 'danger';
        $message = lang('General.response.badRequest') . ' .';

        // Get all the required data
        $code = (! empty($data) && ! empty($data['code'])) ? $data['code'] : '';
        $groupID = (! empty($data) && ! empty($data['group']) && intval($data['group']) > 0) ? intval($data['group']) : 0;

        // Process only if the required data are availables
        if(! empty($code) && ! empty($groupID)) {

            // Get the other data
            $rowID = (! empty($rowID) && intval($rowID) > 0) ? intval($rowID) : 0;
            $tags = (! empty($data) && ! empty($data['tags'])) ? $data['tags'] : '';
            $description = (! empty($data) && ! empty($data['description'])) ? $data['description'] : '';

            // Check if this is not duplicate data
            if(! $this->isDuplicate([
                $this->table . '.' . $this->primaryKey . ' !='  => $rowID,
                $this->table . '.' . 'code'                     => $code,
                $this->table . '.' . 'deleted'                  => 0,
                $this->table . '.' . 'deleted_at'               => null,
                $this->table . '.' . 'deleted_by'               => null
            ]))
            {

                // Check wether we're facing an insertion or an update
                if(! empty($rowID))
                { // Update

                    // Try to get the row that correspond to the specified id
                    $existingRow = $this->list($rowID);

                    // Check wether the row exist or not
                    if(! empty($existingRow))
                    {

                        // Add the new destination
                        $updated = $this->update($rowID, [
                            'code'          => $code,
                            'group_id'      => $groupID,
                            'tags'          => $tags,
                            'description'   => $description,
                        ]);

                        // Check if the row has been successfully created
                        if($updated)
                        {

                            // Set the response details
                            $type = 'success';
                            $message = lang('General.response.updated');

                        } // End if
                        else
                        {

                            // Set the response details
                            $type = 'warning';
                            $message = lang('General.response.server');

                        } // End else

                    } // End if
                    else
                    {

                        // Set the response details
                        $type = 'danger';
                        $message = lang('General.response.notFound');

                    } // End else

                } // End if
                else
                { // Creation

                    // Add the new row
                    $created = $this->save([
                        'group_id'      => $groupID,
                        'code'          => $code,
                        'tags'          => $tags,
                        'description'   => $description,
                        'active'        => 1,
                    ]);

                    // Check if the row has been successfully created
                    if($created)
                    {

                        // Set the response details
                        $type = 'success';
                        $message = lang('General.response.created');

                    } // End if
                    else
                    {

                        // Set the response details
                        $type = 'warning';
                        $message = lang('General.response.server');

                    } // End else

                } // End else

            } // End if
            else
            {

                // Set the response details
                $type = 'danger';
                $message = lang('General.response.duplicated');

            } // End else

        } // End if

        // Set the response
        $response = [
            'type'      => $type,
            'message'   => $message,
        ];

        // Return the response
        return $response;

    } // End function




    /**
     * UDPATE ROW STATUS
     * ENABLE / DISABLE
     * 
     * @param   int    $rowID
     * @param   int    $status
     * 
     * @return  array  $response
     */
    public function updateStatus(int $rowID = 0, int $status = 0)
    {

        // Set the default response data
        $type = 'danger';
        $message = lang('General.response.notFound');

        // Get all the sent informations
        $rowID = (! empty($rowID) && intval($rowID) > 0) ? intval($rowID) : 0;
        $status = (! empty($status) && intval($status) > 0) ? intval($status) : 0;

        // Process only if the required data are available
        if(! empty($rowID)) {

            /**
             * CHECK IF THE SPECIFIED ROW DOES EXIST
             */

            // Get the row details
            $rowDetails = $this->list($rowID);

            // Process only if the row details aray is not empty
            if(! empty($rowDetails)) {

                // Try to update the specified row
                $rowUpdated = $this->update($rowID, [
                    'active'    => $status // Field must be the same as the allowed defined ones
                ]);

                // Process only if the row has been successfully updated
                if($rowUpdated) {

                    // Set the response details
                    $type = 'success';
                    $message = lang('General.response.statusUpdated');

                } // End if
                else {

                    // Set the response details
                    $type = 'danger';
                    $message = lang('General.response.server');


                } // End else

            } // End if
            else {

                // Set the response details
                $type = 'warning';
                $message = lang('General.response.notFound');

            } // End else

        } // End if

        // Set the response
        $response = [
            'type'      => $type,
            'message'   => $message
        ];

        // Retunr the response
        return $response;

    } // End function

    

    /**
     * DELETE A ROW
     * 
     * @param   int    $rowID
     * 
     * @return  array  $response
     */
    public function _delete($rowID = 0)
    {

        // Return the function response
        $type = 'error';
        $message = lang('General.response.badRequest');

        // Process only if the required row's ID is not empty
        if(! empty($rowID) && intval($rowID) > 0) {

            // Try to get the row that correspond to the specified row's ID
            $existingRow = $this->list($rowID);

            // Check wether the row exist or not
            if(! empty($existingRow))
            {

                // Add the new route
                $deleted = $this->delete($rowID);

                // Check if the row has been successfully created
                if($deleted)
                {

                    // Set the message to return
                    $type = 'success';
                    $message = lang('General.response.deleted');

                    // Update the delete informations details
                    $this->update($rowID, [
                        'deleted'       => 1,
                    ]);

                } // End if
                else
                {

                    // Set the response details
                    $type = 'warning';
                    $message = lang('General.response.server');

                } // End else

            } // End if
            else
            {

                // Set the response details
                $type = 'error';
                $message = lang('General.response.notFound');

            } // End else

        } // End if

        // Set the response
        $response = [
            'type'      => $type,
            'message'   => $message,
        ];

        // Return the function response
        return $response;

    } // End function



} // end::ModelSource class