<?php

// Namespace to Models folder
namespace App\Models;

// Call BaseModel Namespace
use App\Models\BaseModel;


// begin::UsersIdentifiersModel class
class UsersIdentifiersModel extends BaseModel
{

    // Model configuration
    protected $table = 'user_identifier';
    protected $primaryKey = 'id';
    
    // Allowed fields for insertion
    protected $allowedFields = ['id', 'user_id', 'name', 'description', 'active', 'deleted', 'created_by', 'deleted_by', 'created_at', 'deleted_at', 'updated_at'];
    
    // Fields available on SELECT query
    protected $selectedFields = 'user_identifier.id, user_identifier.name, user.first_name, user.last_name, user.phone, user.email, user.pwd, user.random_salt';

    // Fields used on filters queries
    // Used by _getDataBy() function
    protected $filtersFields = [
        'name'          => 'user_identifier.name',
        'active'        => 'user_identifier.active',
        'deleted'       => 'user_identifier.deleted',
        'user_active'   => 'user.active',
        'user_deleted'  => 'user.deleted',
    ];

    // Fields used for SEARCH query
    protected $searchFields = [
    ];

    // Fields available for sorting
    protected $sortingFields = [];

    // Set the joins array
    protected $joints = [
        [
            'table'     => 'user',
            'condition' => 'user.id = user_identifier.user_id',
            'type'      => 'inner',
        ],
    ];


    /**
     * AUTHENTICATE A USER
     * USING CREDENTIALS
     * 
     * @param   string  $login
     * 
     * @return  array   $response
     */
    public function isUserLogin(string $login = ''):?array
    {

        // Set the default response to return
        $response = [];

        // Get the received data
        $login = trim($login);

        // Process only if the required data are available
        if(! empty($login)) {

            // Get any row that match the received data
            $response = $this->_getDataBy([
                'name'          => $login,
                'active'        => ACTIVE,
                'deleted'       => INJECTION,
                'user_active'   => ACTIVE,
                'user_deleted'  => INJECTION,
            ]);

        } // End if

        // Return the response
        return $response;

    } // end::isUserLogin


    /**
     * ADD IDENTIFIERS
     * FOR USER ACCOUNT
     * 
     * @param   int    $userID
     * @param   array  $identifiers
     * 
     * @return  array   $response
     */
    public function addIdentifiers(int $userID = 0, array $identifiers = [])
    {

        // Process only if the required data are available
        if(! empty($userID) && ! empty($identifiers)) {

            // Loop through all the identifiers
            foreach($identifiers as $identifier) {

                // Add the current identifier
                $this->save([
                    'user_id'   => $userID,
                    'name'      => $identifier,
                    'active'    => ACTIVE
                ]);

            } // End loop

        } // End if

    } // end::addIdentifiers

} // end::UsersIdentifiersModel class