<?php

// Test
// ...
// var_dump($row);

// Get all the informations for the required page
$rowID = (! empty($row['id']) && intval($row['id']) > 0) ? intval($row['id']) : 0;
$name = (! empty($row['name'])) ? $row['name'] : '';
$description = (! empty($row['description'])) ? $row['description'] : '';
$groupPermissions = (! empty($row['permissions'])) ? $row['permissions'] : [];

// Get all the data list required
$permissions = (! empty($data['permissions'])) ? $data['permissions'] : [];

// Set all the form data
$formID = 'roleForm';
$formTitle = (! empty($rowID) && ! empty($name)) ? ucfirst($name) : ucfirst(lang('Roles.action.new'));
$formHeaderBgColor = (! empty($rowID)) ? 'bg-warning' : 'bg-theme-primary';
$formConfirmBtnColor = (! empty($rowID)) ? 'btn-warning' : 'btn-theme-primary';
$formCancelBtnColor = (! empty($rowID)) ? 'btn-light-warning' : 'btn-light-primary';

?>

<form action="<?= esc($action); ?>" method="post" id="<?= $formID; ?>" enctype="multipart/form-data">

    <?= csrf_field() ?>
    
    <div class="modal-header <?= $formHeaderBgColor; ?>">
        <h5 class="modal-title text-light" id="exampleModalLabel"><?= $formTitle; ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
			<i aria-hidden="true" class="ki ki-close text-light"></i>
		</button>
    </div>
    <div class="modal-body">
        <div class="form-group">
			<label for="txt-name"><?= ucfirst(lang('Roles.field.role.label')); ?> <span class="text-danger">*</span> :</label>
			<input type="text" id="txt-name" name="txt-name" class="form-control form-control-solid" placeholder="<?= ucfirst(lang('Roles.field.role.placeholder')); ?>" value="<?= $name; ?>" />
			<span class="form-text text-muted"><?= ucfirst(lang('Roles.field.role.description')); ?></span>
		</div>
		<div class="form-group">
			<label for="txt-description"><?= ucfirst(lang('Roles.field.description.label')); ?> :</label>
			<textarea id="txt-description" name="txt-description" class="form-control form-control-solid no-resize" placeholder="<?= ucfirst(lang('Roles.field.description.placeholder')); ?>" rows="4"><?= $description; ?></textarea>
			<span class="form-text text-muted"><?= ucfirst(lang('Roles.field.description.description')); ?></span>
		</div>
        <div class="form-group offset-1 col-10">
            <select id="slt-permissions" name="slt-permissions[]" class="dual-listbox" multiple="multiple" 
                data-available-title="<?= ucfirst(lang('Roles.field.permissionList.label')); ?>"
                data-selected-title="<?= ucfirst(lang('Roles.field.selectedPermission.label')); ?>"
                data-add="<i class='flaticon2-next'></i>"
                data-remove="<i class='flaticon2-back'></i>"
                data-add-all="<i class='flaticon2-fast-next'></i>"
                data-remove-all="<i class='flaticon2-fast-back'></i>"
                >
                <?php

                // Check if there is some permissions to display
                if(! empty($permissions))
                {

                    // Loop through all the permissions then display each
                    foreach($permissions as $permission)
                    {

                        // Check if the current permission is already selected
                        $selected = ( in_array($permission['id'], (array)$groupPermissions)) ? 'selected="selected"' : '';

                ?>
                <option value="<?= $permission['id']; ?>" <?= $selected; ?>><?= trim($permission['name']); ?></option>
                <!-- <option value="">1</option> -->
                <?php

                    } // End loop

                } // End if

                ?>
            </select>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn <?= $formCancelBtnColor; ?> font-weight-bold" data-dismiss="modal">
        	<?= ucfirst(lang('General.action.cancel')); ?>
        </button>
        <button type="submit" class="btn <?= $formConfirmBtnColor; ?> font-weight-bold">
        	<span class="svg-icon svg-icon-md">
        		<?= ucfirst(lang('General.action.save')); ?>
        		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
				    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
				        <polygon points="0 0 24 0 24 24 0 24"/>
				        <path d="M9.26193932,16.6476484 C8.90425297,17.0684559 8.27315905,17.1196257 7.85235158,16.7619393 C7.43154411,16.404253 7.38037434,15.773159 7.73806068,15.3523516 L16.2380607,5.35235158 C16.6013618,4.92493855 17.2451015,4.87991302 17.6643638,5.25259068 L22.1643638,9.25259068 C22.5771466,9.6195087 22.6143273,10.2515811 22.2474093,10.6643638 C21.8804913,11.0771466 21.2484189,11.1143273 20.8356362,10.7474093 L17.0997854,7.42665306 L9.26193932,16.6476484 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(14.999995, 11.000002) rotate(-180.000000) translate(-14.999995, -11.000002) "/>
				        <path d="M4.26193932,17.6476484 C3.90425297,18.0684559 3.27315905,18.1196257 2.85235158,17.7619393 C2.43154411,17.404253 2.38037434,16.773159 2.73806068,16.3523516 L11.2380607,6.35235158 C11.6013618,5.92493855 12.2451015,5.87991302 12.6643638,6.25259068 L17.1643638,10.2525907 C17.5771466,10.6195087 17.6143273,11.2515811 17.2474093,11.6643638 C16.8804913,12.0771466 16.2484189,12.1143273 15.8356362,11.7474093 L12.0997854,8.42665306 L4.26193932,17.6476484 Z" fill="#000000" fill-rule="nonzero" transform="translate(9.999995, 12.000002) rotate(-180.000000) translate(-9.999995, -12.000002) "/>
				    </g>
				</svg>
        	</span>
        </button>
    </div>

    <!-- Set all the hidden data -->
    <input type="hidden" name="row-ID" value="<?= $rowID; ?>">
</form>

<script type="text/javascript">
    new DualListbox('.dual-listbox', {
        availableTitle: '<?= ucfirst(lang('Roles.field.permissionList.label')); ?>',
        selectedTitle: '<?= ucfirst(lang('Roles.field.selectedPermission.label')); ?>',
        addButtonText: '<?= ucfirst(lang('Roles.field.add.label')); ?> >',
        removeButtonText: '< <?= ucfirst(lang('Roles.field.remove.label')); ?>',
        addAllButtonText: '<?= ucfirst(lang('Roles.field.addAll.label')); ?> >>',
        removeAllButtonText: '<< <?= ucfirst(lang('Roles.field.removeAll.label')); ?>',
    });
</script>