"use strict";
// Class definition

var customersDataTableCRUD = function() {
    // Private functions

    // Begin Function
    var _main = function() {

        // Set all the required variables for the following methods
        var formModalID = 'customerFormModal',
            formID = 'customerForm',
            dtID = 'customersDatatable',
            dtSearchText = 'customersDatatableSearchQuery',
            dtSearchStatus = 'customersDatatableSearchStatus',
            dtButtons = {
                add: 'customerFormAdd',
                edit: 'customerFormEdit',
                delete: 'customerFormDelete',
                reload: 'reloadDatatable',
            },
            remoteAJAXFunctions = {
                loadData: 'RemoteData/getCustomersJSON',
                form: 'customers/customerForm',
                delete: 'customers/deleteCustomer',
                setForm: 'customers/setCustomer',
            };

        // DataTable for data rows display
        var datatable = $('#' + dtID).KTDatatable({
            // datasource definition
            data: {
                type: 'remote',
                source: {
                    read: {
                        url: BASE_URL + '/' + remoteAJAXFunctions.loadData, // Remote JSON data source
                        map: function(raw) {
                            // sample data mapping
                            var dataSet = raw;
                            if (typeof raw.data !== 'undefined') {
                                dataSet = raw.data;
                            }
                            return dataSet;
                        },
                    },
                },
                pageSize: 10,
                // serverPaging: false,
                // serverFiltering: false,
                // serverSorting: false,

                // Server Side
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true,
            },

            // layout definition
            layout: {
                scroll: false,
                footer: false,
            },

            // column sorting
            sortable: true,

            pagination: true,

            search: {
                input: $('#' + dtSearchText),
                key: 'generalSearch'
            },

            // columns definition
            columns: [{
                field: 'first_name',
                title: LANG_FILE.page.customers.column.customer,
                width: 150,
                template: function(row) {
                    // return '<a target="_blank" href="' + ADMIN_FOLDER + '/Customers/overview/' + row.id + '" class="navi-link">\
                    return '<a href="' + ADMIN_BASE_URL + '/' + LOCALE + '/customers/' + row.id + '/overview" class="navi-link">\
                                <span class="navi-text">' + row.firstName + ' ' + row.lastName + '</span>\
                            </a>';
                },
            }, {
                field: 'email',
                title: LANG_FILE.page.customers.column.email,
                width: 200,
            }, {
                field: 'balance',
                title: LANG_FILE.page.customers.column.balance,
                width: 120,
                template: function(row) {
                    return '<span class="text-info">' + row.balance + ' XOF</span>';
                },
            }, {
                field: 'customCost',
                title: LANG_FILE.page.customers.column.customCost,
                width: 130,
                template: function(row) {
                    return '<span class="label font-weight-bold label-lg label-light-info label-inline">' + row.customCost + ' XOF</span>'
                }
            }, {
                field: 'created_at',
                title: LANG_FILE.general.column.createdAT,
                width: 130,
            // }, {
            //     field: 'active',
            //     title: 'Statut',
            //     width: 80,
            //     // callback function support for column rendering
            //     template: function(row) {
            //         var status = {
            //             1: {
            //                 'title': 'Actif',
            //                 'class': ' label-light-success'
            //             },
            //             0: {
            //                 'title': 'Inactif',
            //                 'class': ' label-light-warning'
            //             },
            //         };

            //         // Return the formated data
            //         return '<span class="label font-weight-bold label-lg ' + status[row.active].class + ' label-inline">' + status[row.active].title + '</span>';
            //     },
            }, {
                field: '',
                title: LANG_FILE.general.column.actions,
                sortable: false,
                width: 70,
                overflow: 'visible',
                autoHide: false,
                template: function(row) {

                    // Delete button
                    let deleteBTN = '<li class="navi-item"><a href="javascript:;" id="' + dtButtons.delete + '" data-row-id="' + row.id + '" class="navi-link"><span class="navi-icon"><i class="la la-remove text-danger"></i></span><span class="navi-text">' + (LANG_FILE.general.action.delete).toLowerCase().replace(/\b[a-z]/g, function(letter){return letter.toUpperCase();}) + '</span></a></li>';

                    // Return the actions dropdown button
                    return '\
                        <div class="dropdown dropdown-inline">\
                            <a href="javascript:;" class="btn btn-sm btn-clean btn-icon mr-2" data-toggle="dropdown">\
                                <span class="svg-icon svg-icon-md svg-icon-primary">\
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
                                            <rect x="0" y="0" width="24" height="24"/>\
                                            <path d="M7,3 L17,3 C19.209139,3 21,4.790861 21,7 C21,9.209139 19.209139,11 17,11 L7,11 C4.790861,11 3,9.209139 3,7 C3,4.790861 4.790861,3 7,3 Z M7,9 C8.1045695,9 9,8.1045695 9,7 C9,5.8954305 8.1045695,5 7,5 C5.8954305,5 5,5.8954305 5,7 C5,8.1045695 5.8954305,9 7,9 Z" fill="#000000"/>\
                                            <path d="M7,13 L17,13 C19.209139,13 21,14.790861 21,17 C21,19.209139 19.209139,21 17,21 L7,21 C4.790861,21 3,19.209139 3,17 C3,14.790861 4.790861,13 7,13 Z M17,19 C18.1045695,19 19,18.1045695 19,17 C19,15.8954305 18.1045695,15 17,15 C15.8954305,15 15,15.8954305 15,17 C15,18.1045695 15.8954305,19 17,19 Z" fill="#000000" opacity="0.3"/>\
                                        </g>\
                                    </svg>\
                                </span>\
                            </a>\
                            <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">\
                                <ul class="navi flex-column navi-hover py-2">\
                                    <li class="navi-item">\
                                        <a target="_blank" href="' + ADMIN_BASE_URL + '/' + LOCALE + '/customers/overview/' + row.id + '" class="navi-link">\
                                            <span class="navi-icon"><i class="la la-gear text-info"></i></span>\
                                            <span class="navi-text">' + (LANG_FILE.general.action.consult).toLowerCase().replace(/\b[a-z]/g, function(letter){return letter.toUpperCase();}) + '</span>\
                                        </a>\
                                    </li>\
                                </ul>\
                            </div>\
                        </div>\
                    ';
                },
            }],

        });

        // Filter the row by status ('active' field)
		$('#' + dtSearchStatus).on('change', function() {

            var status = {
                '1': {
                    'title': 'Actif',
                    'class': ' label-light-success'
                },
                '0': {
                    'title': 'Inactif',
                    'class': ' label-light-warning'
                },
            };

            // Search value within 'active' field
            datatable.search($(this).val().toLowerCase(), 'active');

        });

        // Search actions ...
        $('#' + dtSearchStatus + ', #' + dtSearchText).selectpicker();

        // Reload the datatable on 'ReloadButton' click
        $(document).on('click', '#' + dtButtons.reload, function() {

            // Reload the datatable
            $('#' + dtID).KTDatatable('reload');

        });

        // Function to load on (edit or add) button click
        $(document).on('click', '#' + dtButtons.edit + ', #' + dtButtons.add, function() {

            // Get the selected row id
            var rowId = $(this).attr('data-row-id');

            // AJAX function to load the form data to display
            $.ajax({

                // AJAX Call options
                url: BASE_URL + '/' + remoteAJAXFunctions.form,
                type: "POST",
                data: {
                    'id': rowId,
                },

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                        // Display the loaded data
                        $('#' + formModalID + ' #mainContent').html(data);

                    } // End if

                }, // End success event

            });

        });

        // Function to load on delete button click
        // $(document).on('click', '#' + dtButtons.delete, function() {

        //     // Get the selected row id
        //     let rowId = $(this).attr('data-row-id');

        //     // Swal Pop-Up to confirm or cancel delete action
        //     Swal.fire({
        //         title: "Voulez-vous continuer ?",
        //         text: "Cette action supprimera définitivement la ligne de la base de données !",
        //         icon: "warning",
        //         showCancelButton: true,
        //         confirmButtonText: "Oui, supprimer !",
        //         cancelButtonText: "Non, annuler !",
        //         buttonsStyling: false,
        //         customClass: {
        //             confirmButton: "btn btn-danger",
        //             cancelButton: "btn btn-secondary",
        //         },
        //         reverseButtons: true,
        //     }).then(function(result) {

        //         // Process only if 'confirm' button is clicked
        //         if (result.value) {

        //             // AJAX function to delete the data from server
        //             $.ajax({

        //                 // AJAX Call options
        //                 url: BASE_URL + '/' + remoteAJAXFunctions.delete,
        //                 type: 'POST',
        //                 data: {
        //                     'id': rowId,
        //                 },

        //                 // On 'Success' Event
        //                 success: function(data) {

        //                     // Get the data value
        //                     let serverResponse = JSON.parse(data);

        //                     // Return the processing response to the user
        //                     Swal.fire(
        //                         "Suppression !",
        //                         serverResponse.message,
        //                         serverResponse.type,
        //                     );

        //                 }, // End Success Event
        //             });

        //             // Reload the datatable
        //             $('#' + dtID).KTDatatable('reload');

        //         } // End if
        //     });
        // });

        // Hold then process the form submit event
        $(document).on('submit', '#' + formModalID + ' form', function(e) {

            // Call a block UI
            KTApp.block('#' + formModalID + ' form', {
                overlayColor: '#000000',
                state: 'warning',
                message: 'Traitement...'
            });

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Get all the required data
            let formElement = $('#' + formID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: BASE_URL + '/' + remoteAJAXFunctions.setForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Unblock the content
                    KTApp.unblock('#' + formModalID + ' form');

                    // Get the data value
                    let serverResponse = JSON.parse(data);

                    // Check the response type
                    if(serverResponse.type === 'success')
                    {

                        // Dismiss the form modal
                        $('#' + formModalID).modal('hide');

                        // Push the server response as toast
                        toastr.success(serverResponse.message);

                        // Reload the datatable
                        $('#' + dtID).KTDatatable('reload');

                    } // End if
                    else if(serverResponse.type === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

        });
    }; // End Function

    return {
        // public functions
        init: function() {
            _main();
        },
    };
}();

jQuery(document).ready(function() {
    customersDataTableCRUD.init();
});