<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Auth');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Auth::index');


// Authentification
$routes->get('{locale}', 'Auth::index');
$routes->get('{locale}/authentication', 'Auth::loginForm');
$routes->post('{locale}/sign/in', 'Auth::signIn');
$routes->get('{locale}/sign/out', 'Auth::signOut');

// Home
$routes->get('{locale}/dashboard', 'Home::dashboard');
$routes->get('{locale}/profile', 'Home::profile');
$routes->post('{locale}/profile/set', 'Home::setProfile');
$routes->post('{locale}/passwd/set', 'Home::setPasswd');

// Settings currencies
$routes->get('{locale}/currencies', 'Settings::currencies');
$routes->post('{locale}/currencies/data', 'Settings::getCurrenciesJSON');
$routes->post('{locale}/currency/form', 'Settings::currencyForm');
$routes->post('{locale}/currency/set', 'Settings::setCurrency');
$routes->post('{locale}/currency/status', 'Settings::statusCurrency');
$routes->post('{locale}/currency/delete', 'Settings::deleteCurrency');

// Settings roles
$routes->get('{locale}/roles', 'Settings::roles');
$routes->post('{locale}/roles/data', 'Settings::getRolesJSON');
$routes->post('{locale}/role/form', 'Settings::roleForm');
$routes->post('{locale}/role/set', 'Settings::setRole');
$routes->post('{locale}/role/status', 'Settings::statusRole');
$routes->post('{locale}/role/delete', 'Settings::deleteRole');

// Settings permissions
$routes->get('{locale}/permissions', 'Settings::permissions');
$routes->post('{locale}/permissions/data', 'Settings::getPermissionsJSON');
$routes->post('{locale}/permission/form', 'Settings::permissionForm');
$routes->post('{locale}/permission/set', 'Settings::setPermission');
$routes->post('{locale}/permission/status', 'Settings::statusPermission');
$routes->post('{locale}/permission/delete', 'Settings::deletePermission');

// Settings users
$routes->get('{locale}/users', 'Settings::users');
$routes->post('{locale}/users/data', 'Settings::getUsersJSON');
$routes->post('{locale}/user/form', 'Settings::userForm');
$routes->post('{locale}/user/set', 'Settings::setUser');
$routes->post('{locale}/user/status', 'Settings::statusUser');
$routes->post('{locale}/user/delete', 'Settings::deleteUser');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
