<?php namespace App\Models;

// Call Model Namespace
use CodeIgniter\Model;

// Begin RolePermissionsModel class
class RolePermissionsModel extends Model
{

    // Defined all the required data
    protected $table = 'role_permission';
    protected $primaryKey = 'id';

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;
    
    protected $allowedFields = ['id', 'role_id', 'permission_id'];

    protected $searchFields = [];

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function listRolePermissions($roleId = 0, $idOnly = true)
        {

            // Check wether an id has been specified or not
            if ($roleId === 0)
            {

                // Returns all the rows availables
                return [];

            } // End if

            // Return the row details
            return $this->select('permission_id')
                        ->asArray()
                        ->where(['role_id' => $roleId])
                        ->findAll(); // Return all the items

        } // End function
    //-----------------------------------------------------------------

    //-----------------------------------------------
    // ADD A LIST OF PERMISSIONS TO A SPECIFIED ROLE
    //-----------------------------------------------
        public function addRolePermissions($roleId = 0, $permissions = [], $behaviour = 'replace')
        {

            // Process only if a valid keyword has been provided
            if( ! empty($roleId) && (intval($roleId) > 0) && ! empty($permissions) && is_array($permissions)):
            // if( ! empty($roleId) && (intval($roleId) > 0) && ! empty($permissions) && is_array($permissions)){
            // if(true):

                // if (condition) {
                //     # code...
                // }

                // Process only if the behaviour is to replace data
                if(mb_strtolower($behaviour) !== 'add')
                {

                    // Delete all the previous role permissions from the dataTable
                    $this->where('role_id', $roleId)->delete();
                    // $this->delete('role_id', $roleId);

                } // End if

                // Test
                // ...
                // var_dump($this->set(['role_id' => $roleId])->getCompiledDelete());
                // exit;

                // Loop through all the permissions then add each to the role specified
                // foreach($permissions as $permission):
                foreach($permissions as $permission)
                {
                    
                    // Add the role permission
                    $this->save([
                        'role_id'       => $roleId,
                        'permission_id' => $permission
                    ]);

                } // End loop
                // endforeach; // End loop

            // } // End if
            endif;
            // else { echo 'void'; } // End else


        } // End function
    //-----------------------------------------------
    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function getRolePermissions($roleID = 0)
        {

            // Check wether an id has been specified or not
            if ($roleID === 0)
            {

                // Returns all the rows availables
                return [];

            } // End if

            // Return the row details
            return $this->select('permission.code')
                        ->join('permission', 'role_permission.permission_id = permission.id')
                        ->asArray()
                        ->where(['role_permission.role_id' => $roleID])
                        ->get()
                        ->getResultArray(); // Return all the items

        } // End function
    //-----------------------------------------------------------------

} // End RolePermissionsModel class