<?php namespace App\Models;

// Call Model Namespace
use CodeIgniter\Model;

// Models to import 
use App\Models\RolePermissionsModel; // role permissions

// Begin RolesModel class
class RolesModel extends Model
{

    // Defined all the required data
    protected $table = 'role';
    protected $primaryKey = 'id';

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;
    
    protected $allowedFields = ['id', 'name', 'description', 'active', 'deleted', 'created_by', 'deleted_by', 'created_at', 'deleted_at', 'updated_at'];

    protected $searchFields = ['name', 'description', 'created_at'];
    protected $sortingFields = [
        'name'          => 'name',
        'description'   => 'description',
        'created_at'    => 'created_at',
    ];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function list($id = 0, $options = [])
        {

            // Check wether an id has been specified or not
            if ($id === 0)
            {

                // Get any pagination option specified
                $paging = ( ! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
                $page = ( ! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
                $length = ( ! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
                $sorting = ( ! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
                $field = ( ! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
                $sort = ( ! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

                // Adjust the query if the paging option is specified
                if( ! empty($page))
                {

                    // Set the offset value
                    $offset = ($page - 1) * $length;

                    // Add paging option
                    $this->limit($length, $offset);

                } // End if

                // Adjust the query if the sorting option is specified
                if( ! empty($field)
                    && array_key_exists($field, $this->sortingFields)
                )
                {

                    // Add sorting option
                    $this->orderBy($this->sortingFields[$field], $sort);

                } // End if

                // Returns all the rows availables
                $rows = $this->where([
                                'active'        => 1,
                                'deleted'       => 0,
                                'deleted_by'    => null,
                            ])
                            ->get()
                            ->getResultArray();
                // return $this->findAll();

                // Set the default value of data to return
                $data = [];

                // Process only if the rows variable is not empty
                if( ! empty($rows))
                {

                    // Load the RolePermissions model
                    $rolePermissionsModel = new RolePermissionsModel();

                    // Loop through all the rows then add role permissions
                    foreach($rows as $row)
                    {

                        // Test
                        // ...
                        // var_dump($row);

                        // Get the role permissions
                        // $row['permissions'] = [1, 2];
                        // $row['permissions'] = $rolePermissionsModel->listRolePermissions($row['id']);
                        $permissions = $rolePermissionsModel->listRolePermissions($row['id']);
                        $permissions_array = [];

                        // Process if any permission is returned
                        if( ! empty($permissions))
                        {

                            // Loop through all the permissions then add each to the permissions_array
                            foreach($permissions as $permission)
                            {

                                // Add the permission to permissions_array
                                $permissions_array[] = intval($permission['permission_id']);

                            } // End loop

                        } // End if

                        // Add the role permissions
                        $row['permissions'] = $permissions_array;

                        // Add the new row to the data array to return
                        $data[] = $row;

                        // Test
                        // ...
                        // var_dump($row);

                    } // End loop

                } // End if

                // Test
                // ...
                // exit;

                // Return the rows list
                return $data;

            } // End if

            // Return the row details
            $roleDetails = $this->asArray()
                        ->where([
                            $this->primaryKey => $id
                        ])
                        ->first(); // Return the first item

            // Process only if the roleDetails variable is not empty
            if( ! empty($roleDetails))
            {

                // Load the RolePermissions model
                $rolePermissionsModel = new RolePermissionsModel();

                // Get the role permissions
                $permissions = $rolePermissionsModel->listRolePermissions($id);
                $permissionsArray = [];

                // Process if any permission is returned
                if( ! empty($permissions))
                {

                    // Loop through all the permissions then add each to the permissions Array
                    foreach($permissions as $permission)
                    {

                        // Add the permission to permissions Array
                        $permissionsArray[] = intval($permission['permission_id']);

                    } // End loop

                } // End if

                // Add the role permissions
                $roleDetails['permissions']   = $permissionsArray;

            } // End if

            // Return the row details
            return $roleDetails;

        } // End function
    //-----------------------------------------------------------------

    //------------------------------------------
    // CHECK WETHER A ROW IS A DUPLICATE OR NOT
    //------------------------------------------
        public function isDuplicate($where = [], $orWhere = [])
        {

            // Set the default answer to return
            $isDuplicate = true;

            // Process only if there is a orWhere available
            if( ! empty($orWhere))
            {
                
                $this->groupStart()
                        ->orWhere($orWhere)
                    ->groupEnd();

            } // End if

            // Try to get the row
            $row = $this->where($where)
                        ->get()
                        ->getResultArray();

            // Check the row
            if( empty($row))
            {

                // Set the row as not duplicate
                $isDuplicate = false;

            } // End if

            // Return the answer
            return $isDuplicate;

        } // End function
    //------------------------------------------

    //-------------------------------
    // COUNT ALL THE ROWS AVAILABLES
    //-------------------------------
        public function countTotal($keyword = '', $allFields = true)
        {

            // Process only if the keyword is not empty
            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->countAllResults();

            } // End if

            // Return the rows that match even if the keyword is empty
            return $this->like($this->searchFields[0], $keyword)
                        ->countAllResults();

        } // End function
    //-------------------------------

    //-------------------------------------------
    // LIST ALL THE ROWS THAT MATCHS THE KEYWORD
    //-------------------------------------------
        public function search($keyword = '', $allFields = true, $options = [])
        {

            // Get any pagination option specified
            $paging = ( ! empty($options) && ! empty($options['paging'])) ? $options['paging'] : [];
            $page = ( ! empty($paging) && ! empty($paging['page']) && intval($paging['page']) > 0) ? intval($paging['page']) : 0;
            $length = ( ! empty($paging) && ! empty($paging['length']) && intval($paging['length']) > 0) ? intval($paging['length']) : 20;
            $sorting = ( ! empty($options) && ! empty($options['sorting'])) ? $options['sorting'] : [];
            $field = ( ! empty($sorting) && ! empty($sorting['field'])) ? mb_strtolower($sorting['field']) : '';
            $sort = ( ! empty($sorting) && ! empty($sorting['sort']) && mb_strtoupper($sorting['sort']) === 'ASC') ? 'ASC' : 'DESC';

            // Adjust the query if the paging option is specified
            if( ! empty($page))
            {

                // Set the offset value
                $offset = ($page - 1) * $length;

                // Add paging option
                $this->limit($length, $offset);

            } // End if

            // Adjust the query if the sorting option is specified
            if( ! empty($field)
                && array_key_exists($field, $this->sortingFields)
            )
            {

                // Add sorting option
                $this->orderBy($this->sortingFields[$field], $sort);

            } // End if

            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->get()
                            ->getResultArray();

            } // End if

            // Process only if the keyword is not empty
            return $this->like($this->searchFields[0], $keyword)
                        ->get()
                        ->getResultArray();

        } // End function
    //-------------------------------------------

    //---------------------------------------------------------
    // RETURN AN ARRAY OF COLUMN WHERE TO LOOK FOR THE KEYWORD
    //---------------------------------------------------------
        protected function _searchArray($keyword = '')
        {

            // Set the default data to return
            $data = [];

            // Loop through all the fields then add the keyword as value
            foreach($this->searchFields as $searchField)
            {
                
                // Set a new array item
                $data["$searchField"] = $keyword;

            } // End loop

            // Return data as function response
            return $data;


        } // End function
    //---------------------------------------------------------

} // End RolesModel class