<?php

// Get all the required informations
// ...

// Set all the CRUD variables
$passwdFormID = 'passwordForm';
$passwdButtons = [
	'submit'	=> 'passwordFormSubmit',
];

?>

<!--begin::Form-->
<form class="form" method="post" id="<?= $passwdFormID; ?>" novalidate="novalidate">

	<?= csrf_field() ?>

	<!--begin::Card-->
	<div class="card card-custom">
	    <!--begin::Header-->
	    <div class="card-header py-3">
	        <div class="card-title align-items-start flex-column">
				<h3 class="card-label font-weight-bolder text-dark"><?= ucfirst(lang('Profile.tab.password.title')); ?></h3>
	            <span class="text-muted font-weight-bold font-size-sm mt-1"><?= ucfirst(lang('Profile.tab.password.description')); ?></span>
	        </div>
	        <div class="card-toolbar">
	            <button type="button" class="btn btn-success mr-2" id="<?= $passwdButtons['submit']; ?>">
	            <!-- <button type="submit" class="btn btn-success mr-2" id="<?= $passwdButtons['submit']; ?>"> -->
	            	<?= ucfirst(lang('General.action.save')); ?>
	            	<span class="svg-icon">
		        		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
						    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
						        <polygon points="0 0 24 0 24 24 0 24"/>
						        <path d="M9.26193932,16.6476484 C8.90425297,17.0684559 8.27315905,17.1196257 7.85235158,16.7619393 C7.43154411,16.404253 7.38037434,15.773159 7.73806068,15.3523516 L16.2380607,5.35235158 C16.6013618,4.92493855 17.2451015,4.87991302 17.6643638,5.25259068 L22.1643638,9.25259068 C22.5771466,9.6195087 22.6143273,10.2515811 22.2474093,10.6643638 C21.8804913,11.0771466 21.2484189,11.1143273 20.8356362,10.7474093 L17.0997854,7.42665306 L9.26193932,16.6476484 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(14.999995, 11.000002) rotate(-180.000000) translate(-14.999995, -11.000002) "/>
						        <path d="M4.26193932,17.6476484 C3.90425297,18.0684559 3.27315905,18.1196257 2.85235158,17.7619393 C2.43154411,17.404253 2.38037434,16.773159 2.73806068,16.3523516 L11.2380607,6.35235158 C11.6013618,5.92493855 12.2451015,5.87991302 12.6643638,6.25259068 L17.1643638,10.2525907 C17.5771466,10.6195087 17.6143273,11.2515811 17.2474093,11.6643638 C16.8804913,12.0771466 16.2484189,12.1143273 15.8356362,11.7474093 L12.0997854,8.42665306 L4.26193932,17.6476484 Z" fill="#000000" fill-rule="nonzero" transform="translate(9.999995, 12.000002) rotate(-180.000000) translate(-9.999995, -12.000002) "/>
						    </g>
						</svg>
					</span>
	        	</button>
	        </div>
	    </div>
	    <!--end::Header-->

	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-xl-2"></div>
	    		<div class="col-xl-8">
		            <div class="form-group row">
		                <label class="col-xl-3 col-lg-3 col-form-label text-alert"><?= ucfirst(lang('Profile.field.currentPassword.label')); ?></label>
		                <div class="col-lg-9 col-xl-9">
		                    <input type="password" class="form-control form-control-lg form-control-solid mb-2" value="" placeholder="<?= ucfirst(lang('Profile.field.currentPassword.placeholder')); ?>" name="txt-current" id="txt-current" />
		                    <a href="#" class="text-sm font-weight-bold"><?= ucfirst(lang('ForgotPassword.title')); ?> ?</a>
		                </div>
		            </div>
		            <div class="form-group row">
		                <label class="col-xl-3 col-lg-3 col-form-label text-alert"><?= ucfirst(lang('Profile.field.newPassword.label')); ?></label>
		                <div class="col-lg-9 col-xl-9">
		                    <input type="password" class="form-control form-control-lg form-control-solid" value="" placeholder="<?= ucfirst(lang('Profile.field.newPassword.placeholder')); ?>" name="txt-new" id="txt-new" />
		                </div>
		            </div>
		            <div class="form-group row">
		                <label class="col-xl-3 col-lg-3 col-form-label text-alert"><?= ucfirst(lang('Profile.field.confirmPassword.label')); ?></label>
		                <div class="col-lg-9 col-xl-9">
		                    <input type="password" class="form-control form-control-lg form-control-solid" value="" placeholder="<?= ucfirst(lang('Profile.field.confirmPassword.placeholder')); ?>" name="txt-confirm" id="txt-confirm" />
		                </div>
		            </div>
	            </div>
	    		<div class="col-xl-2"></div>
	        </div>
	    </div>
	</div>
</form>
<!--end::Form-->