<?php

// Set all the CRUD variables
$formModalID = 'permissionFormModal';
$dtID = 'permissionsDatatable';
$dtSearchText = 'permissionsDatatableSearchQuery';
$dtSearchStatus = 'permissionsDatatableSearchStatus';
$dtButtons = [
	'set'		=> 'permissionForm',
	'reload'	=> 'reloadDatatable',
];

?>
<!--begin::Card-->
<div class="card card-custom">
	<div class="card-header flex-wrap border-0 pt-6 pb-0">
		<div class="card-title">
			<h3 class="card-label">
				<?= ucfirst(lang('Permissions.title')); ?>
				<span class="d-block text-muted pt-2 font-size-sm"><?= ucfirst(lang('Permissions.list')); ?></span>
			</h3>
		</div>
		<div class="card-toolbar">

			<!--begin::Button-->
			<button type="button" class="btn btn-theme-primary font-weight-bolder mr-1 <?= $dtButtons['set']; ?>" data-toggle="modal" data-target="#<?= $formModalID; ?>" data-row-id="0">
				<span class="svg-icon svg-icon-md">
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
					    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					        <rect x="0" y="0" width="24" height="24"/>
					        <circle fill="#000000" opacity="0.3" cx="12" cy="12" r="10"/>
					        <path d="M11,11 L11,7 C11,6.44771525 11.4477153,6 12,6 C12.5522847,6 13,6.44771525 13,7 L13,11 L17,11 C17.5522847,11 18,11.4477153 18,12 C18,12.5522847 17.5522847,13 17,13 L13,13 L13,17 C13,17.5522847 12.5522847,18 12,18 C11.4477153,18 11,17.5522847 11,17 L11,13 L7,13 C6.44771525,13 6,12.5522847 6,12 C6,11.4477153 6.44771525,11 7,11 L11,11 Z" fill="#000000"/>
					    </g>
					</svg>
				</span>	<?= ucfirst(lang('General.action.add')); ?>
			</button>
			<!--end::Button-->

			<!--begin::Button-->
			<button type="button" id="<?= $dtButtons['reload']; ?>" class="btn btn-icon btn-theme-light-primary font-weight-bolder" data-card-tool="reload" data-toggle="tooltip" data-placement="top" title="<?= ucfirst(lang('General.action.reload')); ?>">
				<span class="svg-icon svg-icon-md">
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
					    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					        <rect x="0" y="0" width="24" height="24"/>
					        <path d="M8.43296491,7.17429118 L9.40782327,7.85689436 C9.49616631,7.91875282 9.56214077,8.00751728 9.5959027,8.10994332 C9.68235021,8.37220548 9.53982427,8.65489052 9.27756211,8.74133803 L5.89079566,9.85769242 C5.84469033,9.87288977 5.79661753,9.8812917 5.74809064,9.88263369 C5.4720538,9.8902674 5.24209339,9.67268366 5.23445968,9.39664682 L5.13610134,5.83998177 C5.13313425,5.73269078 5.16477113,5.62729274 5.22633424,5.53937151 C5.384723,5.31316892 5.69649589,5.25819495 5.92269848,5.4165837 L6.72910242,5.98123382 C8.16546398,4.72182424 10.0239806,4 12,4 C16.418278,4 20,7.581722 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 L6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,8.6862915 15.3137085,6 12,6 C10.6885336,6 9.44767246,6.42282109 8.43296491,7.17429118 Z" fill="#000000" fill-rule="nonzero"/>
					    </g>
					</svg>
					<!--end::Svg Icon-->
				</span>
			</button>
			<!--end::Button-->
		</div>
	</div>
	<div class="card-body">
		<!--begin::Search Form-->
		<div class="mb-7">
			<div class="row align-items-center">
				<div class="col-lg-9 col-xl-8">
					<div class="row align-items-center">
						<div class="col-md-4 my-2 my-md-0">
							<div class="input-icon">
								<input type="text" class="form-control" placeholder="<?= ucfirst(lang('General.field.search.placeholder')); ?>" id="<?= $dtSearchText; ?>" />
								<span><i class="flaticon2-search-1 text-muted"></i></span>
							</div>
						</div>

        				<div class="col-md-4 my-2 my-md-0">
							<div class="d-flex align-items-center">
								<label class="mr-3 mb-0 d-none d-md-block"><?= ucfirst(lang('General.filter.status')); ?>:</label>
								<select class="form-control" id="<?= $dtSearchStatus; ?>">
									<option value=""><?= ucfirst(lang('General.filter.all')); ?></option>
									<option value="1"><?= ucfirst(lang('General.filter.active')); ?></option>
									<option value="0"><?= ucfirst(lang('General.filter.inactive')); ?></option>
								</select>
							</div>
						</div>
        			</div>
				</div>
			</div>
		</div>
		<!--end::Search Form-->
		<!--begin: Datatable-->
		<div class="datatable datatable-bordered datatable-head-custom" id="<?= $dtID; ?>"></div>
		<!--end: Datatable-->
	</div>
</div>

<!-- Form Modal-->
<div class="modal fade" id="<?= $formModalID; ?>" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" id="mainContent">
        	<!-- Modal Form Content -->
        </div>
    </div>
</div>


<script>
	LANG_FILE['page'] = <?= json_encode($pageDetails['localization']); ?>;
</script>