<?php

// Get all the informations for the required page
$id = (! empty($row->{'id'}) && intval($row->{'id'}) > 0) ? intval($row->{'id'}) : 0;
$name = (! empty($row->{'name'})) ? $row->{'name'} : '';
$description = (! empty($row->{'description'})) ? $row->{'description'} : '';
$pack = (! empty($row->{'pack'})) ? $row->{'pack'} : '';

// Switch the pack value to set the radio button to check by default
// ...

// Set all the form data
$formID = 'reloadingForm';
$formTitle = (! empty($id) && ! empty($name)) ? $name : 'Recharger mon compte';
$formHeaderBgColor = (! empty($id)) ? 'bg-warning' : 'bg-primary';
$formConfirmBtnColor = (! empty($id)) ? 'btn-warning' : 'btn-primary';
$formCancelBtnColor = (! empty($id)) ? 'btn-light-warning' : 'btn-light-primary';
$volumeTouchSpin = 'volumeTouchSpin';
$wizard = 'reloadingWizard';
$formSubmitButton = 'submit-wizard';

// Get all the sent data lists
$packs = (! empty($data) && ! empty($data['packs'])) ? $data['packs'] : [];

// Test
// ...
// var_dump($packs);

?>

<!-- <form action="<?= esc($action); ?>" method="post" id="<?= $formID; ?>" enctype="multipart/form-data"> -->

    <!-- <?= csrf_field() ?> -->
    
    <div class="modal-header <?= $formHeaderBgColor; ?>">
        <h5 class="modal-title text-light" id="exampleModalLabel"><?= $formTitle; ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
			<i aria-hidden="true" class="ki ki-close text-light"></i>
		</button>
    </div>
    <div class="modal-body">
        <!--begin: Wizard-->
        <div class="wizard wizard-2" id="<?= $wizard; ?>" data-wizard-state="step-first" data-wizard-clickable="false">
            <!--begin: Wizard Nav-->
            <div class="wizard-nav border-right pr-8">
            <!-- <div class="wizard-nav border-right py-8 px-8 py-lg-20 px-lg-10"> -->
                <!--begin::Wizard Step 1 Nav-->
                <div class="wizard-steps">
                    <div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
                        <div class="wizard-wrapper">
                            <div class="wizard-icon">
                                <span class="svg-icon svg-icon-2x">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24"/>
                                            <path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                            <path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero"/>
                                        </g>
                                    </svg>
                                </span>
                            </div>
                            <div class="wizard-label">
                                <h3 class="wizard-title">
                                    Package
                                </h3>
                                <div class="wizard-desc">
                                    Choix du pack de reeeeechargement
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Wizard Step 1 Nav-->

                    <!--begin::Wizard Step 2 Nav-->
                    <div class="wizard-step" data-wizard-type="step">
                        <div class="wizard-wrapper">
                            <div class="wizard-icon">
                                <span class="svg-icon svg-icon-2x">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24"/>
                                            <path d="M19,11 L21,11 C21.5522847,11 22,11.4477153 22,12 C22,12.5522847 21.5522847,13 21,13 L19,13 C18.4477153,13 18,12.5522847 18,12 C18,11.4477153 18.4477153,11 19,11 Z M3,11 L5,11 C5.55228475,11 6,11.4477153 6,12 C6,12.5522847 5.55228475,13 5,13 L3,13 C2.44771525,13 2,12.5522847 2,12 C2,11.4477153 2.44771525,11 3,11 Z M12,2 C12.5522847,2 13,2.44771525 13,3 L13,5 C13,5.55228475 12.5522847,6 12,6 C11.4477153,6 11,5.55228475 11,5 L11,3 C11,2.44771525 11.4477153,2 12,2 Z M12,18 C12.5522847,18 13,18.4477153 13,19 L13,21 C13,21.5522847 12.5522847,22 12,22 C11.4477153,22 11,21.5522847 11,21 L11,19 C11,18.4477153 11.4477153,18 12,18 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                            <circle fill="#000000" opacity="0.3" cx="12" cy="12" r="2"/>
                                            <path d="M12,17 C14.7614237,17 17,14.7614237 17,12 C17,9.23857625 14.7614237,7 12,7 C9.23857625,7 7,9.23857625 7,12 C7,14.7614237 9.23857625,17 12,17 Z M12,19 C8.13400675,19 5,15.8659932 5,12 C5,8.13400675 8.13400675,5 12,5 C15.8659932,5 19,8.13400675 19,12 C19,15.8659932 15.8659932,19 12,19 Z" fill="#000000" fill-rule="nonzero"/>
                                        </g>
                                    </svg>
                                </span>
                            </div>
                            <div class="wizard-label">
                                <h3 class="wizard-title">
                                    Volume
                                </h3>
                                <div class="wizard-desc">
                                    D&eacute;finir le volume pour le pack s&eacute;lectionné
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Wizard Step 2 Nav-->

                    <!--begin::Wizard Step 3 Nav-->
                    <div class="wizard-step" data-wizard-type="step">
                        <div class="wizard-wrapper">
                            <div class="wizard-icon">
                                <span class="svg-icon svg-icon-2x">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24"/>
                                            <rect fill="#000000" opacity="0.3" x="2" y="5" width="20" height="14" rx="2"/>
                                            <rect fill="#000000" x="2" y="8" width="20" height="3"/>
                                            <rect fill="#000000" opacity="0.3" x="16" y="14" width="4" height="2" rx="1"/>
                                        </g>
                                    </svg>
                                </span>
                            </div>
                            <div class="wizard-label">
                                <h3 class="wizard-title">
                                    Paiement
                                </h3>
                                <div class="wizard-desc">
                                    Payer via CINETPAY
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Wizard Step 3 Nav-->
                </div>
            </div>
            <!--end: Wizard Nav-->

            <!--begin: Wizard Body-->
            <div class="wizard-body pl-8">
            <!-- <div class="wizard-body py-8 px-8 py-lg-20 px-lg-10"> -->
                <!--begin: Wizard Form-->
                <div class="row">
                    <!-- <div class="offset-xxl-2 col-xxl-8"> -->
                    <div class="col-xxl-12">

                        <!-- <form class="form" action="<?= esc($action); ?>" method="post" id="<?= $formID; ?>" enctype="multipart/form-data"> -->
                        <form class="form" id="<?= $formID; ?>">
                        <!-- <form class="form" id="kt_form"> -->
                            <!--begin: Wizard Step 1-->
                            <div class="pb-5" data-wizard-type="step-content" data-wizard-state="current">
                                <h4 class="mb-10 font-weight-bold text-dark">S&eacute;lectionner un pack</h4>

                                <div class="row">
                                    <?php

                                    // Process only if there is any data to display
                                    if(! empty($packs))
                                    {

                                        // Loop through all the rows then display each
                                        foreach($packs as $item)
                                        {

                                            // Set the default checked status
                                            $checked = '';

                                            // Process only if the current item is the selected one
                                            if($item->{'id'} === $pack)
                                            {
                                                // Set the checked attribute
                                                $checked = 'checked="checked"';

                                            } // End if

                                    ?>
                                    <div class="col-lg-6 mt-3">
                                        <label class="option">
                                            <span class="option-control">
                                                <span class="radio">
                                                    <input type="radio" name="rd-pack" value="<?= $item->{'id'}; ?>" <?= $checked; ?> checked="checked" />
                                                    <span></span>
                                                </span>
                                            </span>
                                            <span class="option-label">
                                                <span class="option-head">
                                                    <span class="option-title">
                                                        <?= $item->{'name'}; ?>
                                                    </span>
                                                    <span class="option-focus">
                                                        <?= $item->{'amount'}; ?> XOF
                                                    </span>
                                                </span>
                                                <span class="option-body">
                                                    <?= nl2br($item->{'description'}); ?>
                                                </span>
                                            </span>
                                        </label>
                                    </div>
                                    <?php

                                        } // End loop

                                    } // End if
                                    else
                                    {

                                    ?>
                                    <!-- <div class="row"> -->
                                        <div class="col-md-12">
                                            <p class="text-center">
                                                Aucun package n'a &eacute;t&eacute; enregistr&eacute; pour votre profil, veuillez consulter votre administrateur !!!
                                            </p>
                                        </div>
                                    <!-- </div> -->
                                    <?php

                                    } // End else

                                    ?>
                                </div>
                            </div>
                            <!--end: Wizard Step 1-->

                            <!--begin: Wizard Step 2-->
                            <div class="pb-5" data-wizard-type="step-content">
                                <h4 class="mb-10 font-weight-bold text-dark">Definir le volume de SMS</h4>
                                <div class="form-group row">
                                    <label class="col-form-label text-right col-lg-3 col-sm-12">Volume</label>
                                    <div class="col-lg-4 col-md-9 col-sm-12">
                                        <input id="<?= $volumeTouchSpin; ?>" type="text" class="form-control" value="0" name="txt-volume" placeholder="Volume" />
                                    </div>
                                </div>
                            </div>
                            <!--end: Wizard Step 2-->

                            <!--begin: Wizard Step 3-->
                            <div class="pb-5" data-wizard-type="step-content">
                                <!--begin::Section-->
                                <h4 class="mb-10 font-weight-bold text-dark">Ma commande</h4>

                                <div class="alert alert-custom alert-default" role="alert">
                                    <div class="alert-icon">
                                        <span class="svg-icon svg-icon-primary svg-icon-xl">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <rect x="0" y="0" width="24" height="24"/>
                                                    <path d="M7.07744993,12.3040451 C7.72444571,13.0716094 8.54044565,13.6920474 9.46808594,14.1079953 L5,23 L4.5,18 L7.07744993,12.3040451 Z M14.5865511,14.2597864 C15.5319561,13.9019016 16.375416,13.3366121 17.0614026,12.6194459 L19.5,18 L19,23 L14.5865511,14.2597864 Z M12,3.55271368e-14 C12.8284271,3.53749572e-14 13.5,0.671572875 13.5,1.5 L13.5,4 L10.5,4 L10.5,1.5 C10.5,0.671572875 11.1715729,3.56793164e-14 12,3.55271368e-14 Z" fill="#000000" opacity="0.3"/>
                                                    <path d="M12,10 C13.1045695,10 14,9.1045695 14,8 C14,6.8954305 13.1045695,6 12,6 C10.8954305,6 10,6.8954305 10,8 C10,9.1045695 10.8954305,10 12,10 Z M12,13 C9.23857625,13 7,10.7614237 7,8 C7,5.23857625 9.23857625,3 12,3 C14.7614237,3 17,5.23857625 17,8 C17,10.7614237 14.7614237,13 12,13 Z" fill="#000000" fill-rule="nonzero"/>
                                                </g>
                                            </svg>
                                        </span>
                                    </div>
                                    <div class="alert-text">
                                        Pour terminer le paiement, vous serez redirig&eacute; vers la page de paiement de <code>CINETPAY</code>. Il s'agit de page de paiement s&eacute;curis&eacute;e !
                                    </div>
                                </div>


                                <div class="card card-custom wave wave-animate-slow wave-success">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center p-5">
                                            <div class="mr-10">
                                                <span class="svg-icon svg-icon-success svg-icon-4x">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                            <rect x="0" y="0" width="24" height="24"/>
                                                            <polygon fill="#000000" opacity="0.3" points="5 3 19 3 23 8 1 8"/>
                                                            <polygon fill="#000000" points="23 8 12 20 1 8"/>
                                                        </g>
                                                    </svg>
                                                </span>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <a href="javascript:;" class="text-dark text-hover-primary font-weight-bold font-size-h4 mb-3">
                                                    Achat de <span id="span-title-order-volume">{VOLUME}</span> SMS
                                                </a>
                                                <div class="text-dark-75">
                                                    <ul class="list-unstyled">
                                                        <li class="font-weight-bold">-> <span class="font-weight-bold text-primary" id="span-li-order-amount">{ORDER_AMOUNT}</span> XOF TTC</li>
                                                        <li class="font-weight-bold">-> Formule <span class="font-weight-bolder" id="span-li-formule-name">{FORMULE_NAME}</span></li>
                                                        <li class="font-weight-bold">-> <span class="font-weight-bold text-primary" id="span-li-formule-cost">{FORMULE_COST}</span> Fcfa / SMS</li>
                                                        <li class="font-weight-bold">-> Volume de <span class="font-weight-bolder" id="span-li-order-volume">{VOLUME}</span> SMS</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end: Wizard Step 3-->

                            <!--begin: Wizard Actions-->
                            <div class="d-flex justify-content-between border-top mt-5 pt-10">
                                <div class="mr-2">
                                    <button type="button" class="btn btn-light-primary font-weight-bold text-uppercase px-9 py-4" data-wizard-type="action-prev">
                                        Pr&eacute;c&eacute;dent
                                    </button>
                                </div>
                                <div>
                                    <button id="<?= $formSubmitButton; ?>" type="button" class="btn btn-success font-weight-bold text-uppercase px-9 py-4" data-wizard-type="action-submit">
                                        Payer
                                    </button>
                                    <button type="button" class="btn btn-primary font-weight-bold text-uppercase px-9 py-4" data-wizard-type="action-next">
                                        Suivant
                                    </button>
                                </div>
                            </div>
                            <!--end: Wizard Actions-->


                            <!-- Hidden Fields -->
                            <input type="hidden" name="pack-id" id="pack-id" value="{FORMULE_ID}" />
                            <input type="hidden" name="pack-name" id="pack-name" value="{FORMULE_NAME}" />
                            <input type="hidden" name="pack-cost" id="pack-cost" value="{FORMULE_COST}" />
                        </form>
                    </div>
                    <!--end: Wizard-->
                </div>
                <!--end: Wizard Form-->
            </div>
            <!--end: Wizard Body-->
        </div>
        <!--end: Wizard-->
    </div>

    <!-- Set all the hidden data -->
    <!-- <input type="hidden" name="hd-id" value="<?= $id; ?>"> -->
<!-- </form> -->

<!-- Call the page scripts -->
<script src="<?= base_url(); ?>/assets/themes/layout1/js/pages/custom/wizard/reloading.js"></script>