"use strict";

// Class definition
var ReloadingWizard = function () {
	// Base elements
	var _wizardEl;
	var _formEl;
	var _wizard;
	var _validations = [];

	// Set the form components informations
	var dtID = 'reloadingDatatable';
	var customersDataTableID = 'customersDatatable';
	var formModalID = 'reloadingFormModal';
	var paymentFormID = 'cinetPayPaymentForm';
	var formWizardID = 'reloadingWizard';
	var formID = 'reloadingForm';
    var defaultListLength = 20,
    	sltCustomersID = 'slt-customer';
	var formComponents = {
		packsRadio: 'rd-pack',
		touchSpin: 'volumeTouchSpin',
		wizardSubmit: 'submit-wizard',
	};
	var hiddenFields = {
		formule: {
			id: "pack-id",
			name: "pack-name",
			cost: "pack-cost",
		},
		customerID: 'hidden-data-customer-ID',
	};
	var orderDetails = {
		client: {
			name: "order-client-name"
		},
		volume: {
			title: 'span-title-order-volume',
			li: 'span-li-order-volume',
		},
		amount: 'span-li-order-amount',
		formule: {
			name: "span-li-formule-name",
			cost: "span-li-formule-cost",
		},
	};
    var remoteAJAXFunctions = {
        touchSpinData: 'RemoteData/getPackDetailsJSON',
        customersListURL: 'RemoteData/getCustomersSelectOptions',
        setForm: 'customers/setReloading',
    };
    var selectedPackRadio;

	// Private functions
	var initWizard = function () {
		// Initialize form wizard
		_wizard = new KTWizard(_wizardEl, {
			startStep: 1, // initial active step number
			clickableSteps: false // to make steps clickable this set value true and add data-wizard-clickable="true" in HTML for class="wizard" element
		});

		// Validation before going to next page
		_wizard.on('beforeNext', function (wizard) {
			// Don't go to the next step yet
			_wizard.stop();

			// Validate form
			var validator = _validations[wizard.getStep() - 1]; // get validator for current step
			validator.validate().then(function (status) {
				if (status == 'Valid') {
					_wizard.goNext();
					KTUtil.scrollTop();
				} else {
					Swal.fire({
						text: "Vous devez sélectionner un client",
						icon: "error",
						buttonsStyling: false,
						confirmButtonText: "Compris!",
						customClass: {
							confirmButton: "btn font-weight-bold btn-light"
						}
					}).then(function () {
						KTUtil.scrollTop();
					});
				}
			});

			/**
			 * UPDATE THE ORDER DETAILS
			 */

			$.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.touchSpinData + '/' + $('#' + hiddenFields.formule.id).val(),
                type: "POST",

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                    	// Get the serverResponse data
                    	var serverResponse = JSON.parse(data);

                    	// Get the volume value
                    	var volume = $('#' + formComponents.touchSpin).val();
                    	var amount = volume * serverResponse.localCost;

                    	// Update the data
                    	$('#' + orderDetails.volume.title).text(volume);
                    	$('#' + orderDetails.volume.li).text(volume);
                    	$('#' + orderDetails.formule.name).text(serverResponse.name);
                    	$('#' + orderDetails.formule.cost).text(serverResponse.localCost);
                    	$('#' + orderDetails.amount).text(amount);

                    	// Hidden fields
                    	$('#' + hiddenFields.formule.id).val(serverResponse.id);
                    	$('#' + hiddenFields.formule.name).val(serverResponse.name);
                    	$('#' + hiddenFields.formule.cost).val(serverResponse.localCost);

                    } // End if

                }, // End success event

            });
		});

		// Change event
		_wizard.on('change', function (wizard) {
			KTUtil.scrollTop();
		});
	}

	var initValidation = function () {
		// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
		// Step 1
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					fname: {
						validators: {
							notEmpty: {
								message: 'First name is required'
							}
						}
					},
					lname: {
						validators: {
							notEmpty: {
								message: 'Last Name is required'
							}
						}
					},
					phone: {
						validators: {
							notEmpty: {
								message: 'Phone is required'
							}
						}
					},
					email: {
						validators: {
							notEmpty: {
								message: 'Email is required'
							},
							emailAddress: {
								message: 'The value is not a valid email address'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 2
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					"slt-customer": {
						validators: {
							notEmpty: {
								message: 'Le choix du client est obligatoire !'
							}
						}
					},
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 3
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					delivery: {
						validators: {
							notEmpty: {
								message: 'Delivery type is required'
							}
						}
					},
					packaging: {
						validators: {
							notEmpty: {
								message: 'Packaging type is required'
							}
						}
					},
					preferreddelivery: {
						validators: {
							notEmpty: {
								message: 'Preferred delivery window is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 4
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					locaddress1: {
						validators: {
							notEmpty: {
								message: 'Address is required'
							}
						}
					},
					locpostcode: {
						validators: {
							notEmpty: {
								message: 'Postcode is required'
							}
						}
					},
					loccity: {
						validators: {
							notEmpty: {
								message: 'City is required'
							}
						}
					},
					locstate: {
						validators: {
							notEmpty: {
								message: 'State is required'
							}
						}
					},
					loccountry: {
						validators: {
							notEmpty: {
								message: 'Country is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 5
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					ccname: {
						validators: {
							notEmpty: {
								message: 'Credit card name is required'
							}
						}
					},
					ccnumber: {
						validators: {
							notEmpty: {
								message: 'Credit card number is required'
							},
							creditCard: {
								message: 'The credit card number is not valid'
							}
						}
					},
					ccmonth: {
						validators: {
							notEmpty: {
								message: 'Credit card month is required'
							}
						}
					},
					ccyear: {
						validators: {
							notEmpty: {
								message: 'Credit card year is required'
							}
						}
					},
					cccvv: {
						validators: {
							notEmpty: {
								message: 'Credit card CVV is required'
							},
							digits: {
								message: 'The CVV value is not valid. Only numbers is allowed'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));
	}

	var initComponents = function() {

		// Set the touchspin on pack selection
		$(document).on('change', 'input[type=radio][name=' + formComponents.packsRadio + ']', function () {

			// Set the hidden field value
			$('#' + hiddenFields.formule.id).val(this.value);

			// Set the touchspin data
			setTouchSpin(this.value);

		});

		// Init the touchspin
		$('#' + formID + ' #' + formComponents.touchSpin).TouchSpin({
			buttondown_class: 'btn btn-secondary',
			buttonup_class: 'btn btn-secondary',
		});

		// Set the touchspin default value
		// ...

		// 'use strict';
		function setTouchSpin(pack) {

			// AJAX function to load the form data to display
            $.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.touchSpinData + '/' + pack,
                type: "POST",

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                    	// Test
                    	// ...
                    	// console.log(data);

                    	// Get the serverResponse data
                    	var serverResponse = JSON.parse(data);

                        // Init the touchspin
                        $('#' + formID + ' #' + formComponents.touchSpin).trigger('touchspin.updatesettings', {

							initVal: serverResponse.min,
							min: serverResponse.min,
							max: serverResponse.max,
							step: serverResponse.step,
						});

                    } // End if

                }, // End success event

            });

		} // End function

		// ...
		selectedPackRadio = $('input[type=radio][name=' + formComponents.packsRadio + ']:checked').val();
		setTouchSpin(selectedPackRadio);




        // Init Select2 plugins for customers select
        $('#' + formID + ' #' + sltCustomersID ).select2({
            placeholder: "Choisir le client",
            // dropdownParent: $(this).parent(),
            ajax: {
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.customersListURL,
                dataType: 'json',
                delay: 250,
                // width: auto,
                data: function (params) {
                    return {
                        q: params.term, // search term
                        page: params.page,
                        length: defaultListLength,
                        // customerID: ($('#' + hiddenFields.customerID)) ? parseInt($('#' + hiddenFields.customerID).val()) : 0
                    };
                },
                processResults: function (data, params) {

                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    params.page = params.page || 1;

                    return {
                        results: $.map(data.items, function (obj) {

                        	// Get any hidden customer ID
                        	// let customerID = ($('#' + hiddenFields.customerID)) ? parseInt($('#' + hiddenFields.customerID).val()) : 0;


                        	// Test
                        	// ...
                        	// console.log(customerID);
                        	// // console.log(obj);
                        	// console.log(obj.id);
                        	// console.log(obj.id == customerID);


                        	// // Process only if there is a specified customer
                        	// if(customerID !== 0) {

	                        // 	// Return only the selected customer
	                        // 	if(obj.id !== customerID) {

	                        // 		// Return void
	                        // 		return;

	                        // 	} // End if

	                        // } // End if

                            return {
                                text: (obj.firstName + ' ' + obj.lastName).trim() + ' (' + obj.email + ')',
                                id: obj.id,
                                fullName: (obj.firstName + ' ' + obj.lastName).trim(),
                            }
                        }),
                        pagination: {
                            more: (params.page * defaultListLength) < data.total_count
                        }
                    };

                },
                cache: true
            },
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
        });

        // Trigger a select2:Select event
		$('#' + sltCustomersID ).on('select2:select', function (e) {

			// Get the selected option using the data source object
		    var optionData = e.params.data;

		    // Test
		    // ...
		    // console.log(optionData);

        	// Update the client data
        	$('#' + orderDetails.client.name).text(optionData.fullName);
		});

		// Set the hidden field value
		$('#' + hiddenFields.formule.id).val(selectedPackRadio);


		//******************************
		// SET THE RELOADING USING AJAX
		//******************************
		function setReloading() {

            // Swal Pop-Up to confirm or cancel delete action
            Swal.fire({
                title: "Voulez-vous continuer ?",
                text: "Attention vous êtes sur le point de recharger un compte client !",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Oui, recharger !",
                cancelButtonText: "Non, annuler !",
                buttonsStyling: false,
                customClass: {
                    confirmButton: "btn btn-danger",
                    cancelButton: "btn btn-secondary",
                },
                reverseButtons: true,
            }).then(function(result) {

                // Process only if 'confirm' button is clicked
                if (result.value) {


		            // Call a block UI
		            KTApp.block('#' + formModalID + ' form', {
		                overlayColor: '#000000',
		                state: 'warning',
		                message: 'Rechagement en cours, veuillez patienter...',
		            });

		            // Get all the required data
		            var formElement = $('#' + formID),
		                formData = new FormData(formElement[0]);

		            // AJAX Function to post the form data to database
		            $.ajax({

		                // AJAX Call options
		                url: ADMIN_BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.setForm,
		                type: 'POST',
		                processData: false,
		                contentType: false,
		                data: formData,

		                // On 'Success' Event
		                success: function(data) {

		                    // Set the toast options
		                    toastr.options = {
		                      "closeButton": true,
		                      "debug": false,
		                      "newestOnTop": true,
		                      "progressBar": false,
		                      "positionClass": "toast-top-right",
		                      "preventDuplicates": false,
		                      "onclick": null,
		                      "showDuration": "300",
		                      "hideDuration": "1000",
		                      "timeOut": "7000",
		                      "extendedTimeOut": "600",
		                      "showEasing": "swing",
		                      "hideEasing": "linear",
		                      "showMethod": "fadeIn",
		                      "hideMethod": "fadeOut"
		                    };

		                    // Unblock the content
		                    KTApp.unblock('#' + formModalID + ' form');

		                    // Get the data value
		                    var serverResponse = JSON.parse(data);

		                    // Check the response type
		                    if(serverResponse.type === 'success')
		                    {

		                        // Dismiss the form modal
		                        $('#' + formModalID).modal('hide');

		                        // Push the server response as toast
		                        toastr.success(serverResponse.message);

		                        // Check if there is any dataTable before reload the dataTable
		                        if(typeof($('#' + dtID)) !== undefined) {

		                            // Reload the datatable
		                            $('#' + dtID).KTDatatable('reload');

		                        } // End else

		                        // Check if there is any dataTable before reload the dataTable
		                        if(typeof($('#' + customersDataTableID)) !== undefined) {

		                            // Reload the datatable
		                            $('#' + customersDataTableID).KTDatatable('reload');

		                        } // End else

		                    } // End if
		                    else if(serverResponse.type === 'warning')
		                    {

		                        // Push the server response as toast
		                        toastr.warning(serverResponse.message);

		                    } // End else if
		                    else
		                    {

		                        // Push the server response as toast
		                        toastr.error(serverResponse.message);

		                    } // End else

		                }, // End Success Event
		            });

                } // End if
            });

		}
		//******************************



        // Hold then process the form submit event
        $('#' + formModalID + ' form').on('submit', function(e) {
        // $(document).on('submit', '#' + formModalID + ' form', function(e) {

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Call the processing function
            setReloading();

        });



        // Process the form on submit button click
		$('#' + formComponents.wizardSubmit).on( 'click' , function() {
        // $(document).on('click', '#' + formComponents.wizardSubmit, function() {

        	// Call the processing function
            setReloading();

        });

	}

	return {
		// public functions
		init: function () {
			_wizardEl = KTUtil.getById(formWizardID);
			_formEl = KTUtil.getById(formID);


			initWizard();
			initValidation();

			initComponents(); // Reloading form components

		}
	};
}();

jQuery(document).ready(function () {
	ReloadingWizard.init();
});
